// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.RedisEnterprise
{
    internal class RedisEnterpriseClusterOperationSource : IOperationSource<RedisEnterpriseClusterResource>
    {
        private readonly ArmClient _client;

        internal RedisEnterpriseClusterOperationSource(ArmClient client)
        {
            _client = client;
        }

        RedisEnterpriseClusterResource IOperationSource<RedisEnterpriseClusterResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = RedisEnterpriseClusterData.DeserializeRedisEnterpriseClusterData(document.RootElement);
            return new RedisEnterpriseClusterResource(_client, data);
        }

        async ValueTask<RedisEnterpriseClusterResource> IOperationSource<RedisEnterpriseClusterResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = RedisEnterpriseClusterData.DeserializeRedisEnterpriseClusterData(document.RootElement);
            return new RedisEnterpriseClusterResource(_client, data);
        }
    }
}
