// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.RedisEnterprise
{
    internal class AccessPolicyAssignmentOperationSource : IOperationSource<AccessPolicyAssignmentResource>
    {
        private readonly ArmClient _client;

        internal AccessPolicyAssignmentOperationSource(ArmClient client)
        {
            _client = client;
        }

        AccessPolicyAssignmentResource IOperationSource<AccessPolicyAssignmentResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = AccessPolicyAssignmentData.DeserializeAccessPolicyAssignmentData(document.RootElement);
            return new AccessPolicyAssignmentResource(_client, data);
        }

        async ValueTask<AccessPolicyAssignmentResource> IOperationSource<AccessPolicyAssignmentResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = AccessPolicyAssignmentData.DeserializeAccessPolicyAssignmentData(document.RootElement);
            return new AccessPolicyAssignmentResource(_client, data);
        }
    }
}
