// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using Azure.Core;

namespace Azure.ResourceManager.RedisEnterprise.Mocking
{
    /// <summary> A class to add extension methods to ArmClient. </summary>
    public partial class MockableRedisEnterpriseArmClient : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableRedisEnterpriseArmClient"/> class for mocking. </summary>
        protected MockableRedisEnterpriseArmClient()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableRedisEnterpriseArmClient"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableRedisEnterpriseArmClient(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        internal MockableRedisEnterpriseArmClient(ArmClient client) : this(client, ResourceIdentifier.Root)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary>
        /// Gets an object representing a <see cref="RedisEnterpriseClusterResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="RedisEnterpriseClusterResource.CreateResourceIdentifier" /> to create a <see cref="RedisEnterpriseClusterResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="RedisEnterpriseClusterResource"/> object. </returns>
        public virtual RedisEnterpriseClusterResource GetRedisEnterpriseClusterResource(ResourceIdentifier id)
        {
            RedisEnterpriseClusterResource.ValidateResourceId(id);
            return new RedisEnterpriseClusterResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="RedisEnterpriseDatabaseResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="RedisEnterpriseDatabaseResource.CreateResourceIdentifier" /> to create a <see cref="RedisEnterpriseDatabaseResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="RedisEnterpriseDatabaseResource"/> object. </returns>
        public virtual RedisEnterpriseDatabaseResource GetRedisEnterpriseDatabaseResource(ResourceIdentifier id)
        {
            RedisEnterpriseDatabaseResource.ValidateResourceId(id);
            return new RedisEnterpriseDatabaseResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="AccessPolicyAssignmentResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="AccessPolicyAssignmentResource.CreateResourceIdentifier" /> to create an <see cref="AccessPolicyAssignmentResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="AccessPolicyAssignmentResource"/> object. </returns>
        public virtual AccessPolicyAssignmentResource GetAccessPolicyAssignmentResource(ResourceIdentifier id)
        {
            AccessPolicyAssignmentResource.ValidateResourceId(id);
            return new AccessPolicyAssignmentResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="RedisEnterprisePrivateEndpointConnectionResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="RedisEnterprisePrivateEndpointConnectionResource.CreateResourceIdentifier" /> to create a <see cref="RedisEnterprisePrivateEndpointConnectionResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="RedisEnterprisePrivateEndpointConnectionResource"/> object. </returns>
        public virtual RedisEnterprisePrivateEndpointConnectionResource GetRedisEnterprisePrivateEndpointConnectionResource(ResourceIdentifier id)
        {
            RedisEnterprisePrivateEndpointConnectionResource.ValidateResourceId(id);
            return new RedisEnterprisePrivateEndpointConnectionResource(Client, id);
        }
    }
}
