// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.RedisEnterprise.Models
{
    /// <summary> Model factory for models. </summary>
    public static partial class ArmRedisEnterpriseModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="Models.RedisEnterpriseOperationStatus"/>. </summary>
        /// <param name="id"> The operation's unique id. </param>
        /// <param name="name"> The operation's name. </param>
        /// <param name="startOn"> The start time of the operation. </param>
        /// <param name="endOn"> The end time of the operation. </param>
        /// <param name="status"> The current status of the operation. </param>
        /// <param name="error"> Error response describing why the operation failed. </param>
        /// <returns> A new <see cref="Models.RedisEnterpriseOperationStatus"/> instance for mocking. </returns>
        public static RedisEnterpriseOperationStatus RedisEnterpriseOperationStatus(ResourceIdentifier id = null, string name = null, DateTimeOffset? startOn = null, DateTimeOffset? endOn = null, string status = null, ResponseError error = null)
        {
            return new RedisEnterpriseOperationStatus(
                id,
                name,
                startOn,
                endOn,
                status,
                error != null ? new ErrorResponse(error, serializedAdditionalRawData: null) : null,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="RedisEnterprise.RedisEnterpriseClusterData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="sku"> The SKU to create, which affects price, performance, and features. </param>
        /// <param name="zones"> The Availability Zones where this cluster will be deployed. </param>
        /// <param name="identity"> The identity of the resource. </param>
        /// <param name="highAvailability"> Enabled by default. If highAvailability is disabled, the data set is not replicated. This affects the availability SLA, and increases the risk of data loss. </param>
        /// <param name="minimumTlsVersion"> The minimum TLS version for the cluster to support, e.g. '1.2'. Newer versions can be added in the future. Note that TLS 1.0 and TLS 1.1 are now completely obsolete -- you cannot use them. They are mentioned only for the sake of consistency with old API versions. </param>
        /// <param name="customerManagedKeyEncryption"> Encryption-at-rest configuration for the cluster. </param>
        /// <param name="hostName"> DNS name of the cluster endpoint. </param>
        /// <param name="provisioningState"> Current provisioning status of the cluster. </param>
        /// <param name="redundancyMode"> Explains the current redundancy strategy of the cluster, which affects the expected SLA. </param>
        /// <param name="resourceState"> Current resource status of the cluster. </param>
        /// <param name="redisVersion"> Version of redis the cluster supports, e.g. '6'. </param>
        /// <param name="privateEndpointConnections"> List of private endpoint connections associated with the specified Redis Enterprise cluster. </param>
        /// <returns> A new <see cref="RedisEnterprise.RedisEnterpriseClusterData"/> instance for mocking. </returns>
        public static RedisEnterpriseClusterData RedisEnterpriseClusterData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, RedisEnterpriseSku sku = null, IEnumerable<string> zones = null, ManagedServiceIdentity identity = null, RedisEnterpriseHighAvailability? highAvailability = null, RedisEnterpriseTlsVersion? minimumTlsVersion = null, RedisEnterpriseCustomerManagedKeyEncryption customerManagedKeyEncryption = null, string hostName = null, RedisEnterpriseProvisioningStatus? provisioningState = null, RedisEnterpriseRedundancyMode? redundancyMode = null, RedisEnterpriseClusterResourceState? resourceState = null, string redisVersion = null, IEnumerable<RedisEnterprisePrivateEndpointConnectionData> privateEndpointConnections = null)
        {
            tags ??= new Dictionary<string, string>();
            zones ??= new List<string>();
            privateEndpointConnections ??= new List<RedisEnterprisePrivateEndpointConnectionData>();

            return new RedisEnterpriseClusterData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                sku,
                zones?.ToList(),
                identity,
                highAvailability,
                minimumTlsVersion,
                customerManagedKeyEncryption != null ? new ClusterPropertiesEncryption(customerManagedKeyEncryption, serializedAdditionalRawData: null) : null,
                hostName,
                provisioningState,
                redundancyMode,
                resourceState,
                redisVersion,
                privateEndpointConnections?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="RedisEnterprise.RedisEnterprisePrivateEndpointConnectionData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="privateEndpointId"> The resource of private end point. </param>
        /// <param name="connectionState"> A collection of information about the state of the connection between service consumer and provider. </param>
        /// <param name="provisioningState"> The provisioning state of the private endpoint connection resource. </param>
        /// <returns> A new <see cref="RedisEnterprise.RedisEnterprisePrivateEndpointConnectionData"/> instance for mocking. </returns>
        public static RedisEnterprisePrivateEndpointConnectionData RedisEnterprisePrivateEndpointConnectionData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, ResourceIdentifier privateEndpointId = null, RedisEnterprisePrivateLinkServiceConnectionState connectionState = null, RedisEnterprisePrivateEndpointConnectionProvisioningState? provisioningState = null)
        {
            return new RedisEnterprisePrivateEndpointConnectionData(
                id,
                name,
                resourceType,
                systemData,
                privateEndpointId != null ? ResourceManagerModelFactory.SubResource(privateEndpointId) : null,
                connectionState,
                provisioningState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.RedisEnterpriseClusterPatch"/>. </summary>
        /// <param name="sku"> The SKU to create, which affects price, performance, and features. </param>
        /// <param name="identity"> The identity of the resource. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="highAvailability"> Enabled by default. If highAvailability is disabled, the data set is not replicated. This affects the availability SLA, and increases the risk of data loss. </param>
        /// <param name="minimumTlsVersion"> The minimum TLS version for the cluster to support, e.g. '1.2'. Newer versions can be added in the future. Note that TLS 1.0 and TLS 1.1 are now completely obsolete -- you cannot use them. They are mentioned only for the sake of consistency with old API versions. </param>
        /// <param name="customerManagedKeyEncryption"> Encryption-at-rest configuration for the cluster. </param>
        /// <param name="hostName"> DNS name of the cluster endpoint. </param>
        /// <param name="provisioningState"> Current provisioning status of the cluster. </param>
        /// <param name="redundancyMode"> Explains the current redundancy strategy of the cluster, which affects the expected SLA. </param>
        /// <param name="resourceState"> Current resource status of the cluster. </param>
        /// <param name="redisVersion"> Version of redis the cluster supports, e.g. '6'. </param>
        /// <param name="privateEndpointConnections"> List of private endpoint connections associated with the specified Redis Enterprise cluster. </param>
        /// <returns> A new <see cref="Models.RedisEnterpriseClusterPatch"/> instance for mocking. </returns>
        public static RedisEnterpriseClusterPatch RedisEnterpriseClusterPatch(RedisEnterpriseSku sku = null, ManagedServiceIdentity identity = null, IDictionary<string, string> tags = null, RedisEnterpriseHighAvailability? highAvailability = null, RedisEnterpriseTlsVersion? minimumTlsVersion = null, RedisEnterpriseCustomerManagedKeyEncryption customerManagedKeyEncryption = null, string hostName = null, RedisEnterpriseProvisioningStatus? provisioningState = null, RedisEnterpriseRedundancyMode? redundancyMode = null, RedisEnterpriseClusterResourceState? resourceState = null, string redisVersion = null, IEnumerable<RedisEnterprisePrivateEndpointConnectionData> privateEndpointConnections = null)
        {
            tags ??= new Dictionary<string, string>();
            privateEndpointConnections ??= new List<RedisEnterprisePrivateEndpointConnectionData>();

            return new RedisEnterpriseClusterPatch(
                sku,
                identity,
                tags,
                highAvailability,
                minimumTlsVersion,
                customerManagedKeyEncryption != null ? new ClusterPropertiesEncryption(customerManagedKeyEncryption, serializedAdditionalRawData: null) : null,
                hostName,
                provisioningState,
                redundancyMode,
                resourceState,
                redisVersion,
                privateEndpointConnections?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="RedisEnterprise.RedisEnterpriseDatabaseData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="clientProtocol"> Specifies whether redis clients can connect using TLS-encrypted or plaintext redis protocols. Default is TLS-encrypted. </param>
        /// <param name="port"> TCP port of the database endpoint. Specified at create time. Defaults to an available port. </param>
        /// <param name="provisioningState"> Current provisioning status of the database. </param>
        /// <param name="resourceState"> Current resource status of the database. </param>
        /// <param name="clusteringPolicy"> Clustering policy - default is OSSCluster. This property must be chosen at create time, and cannot be changed without deleting the database. </param>
        /// <param name="evictionPolicy"> Redis eviction policy - default is VolatileLRU. </param>
        /// <param name="persistence"> Persistence settings. </param>
        /// <param name="modules"> Optional set of redis modules to enable in this database - modules can only be added at creation time. </param>
        /// <param name="geoReplication"> Optional set of properties to configure geo replication for this database. </param>
        /// <param name="redisVersion"> Version of Redis the database is running on, e.g. '6.0'. </param>
        /// <param name="deferUpgrade"> Option to defer upgrade when newest version is released - default is NotDeferred. Learn more: https://aka.ms/redisversionupgrade. </param>
        /// <param name="accessKeysAuthentication"> This property can be Enabled/Disabled to allow or deny access with the current access keys. Can be updated even after database is created. </param>
        /// <returns> A new <see cref="RedisEnterprise.RedisEnterpriseDatabaseData"/> instance for mocking. </returns>
        public static RedisEnterpriseDatabaseData RedisEnterpriseDatabaseData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, RedisEnterpriseClientProtocol? clientProtocol = null, int? port = null, RedisEnterpriseProvisioningStatus? provisioningState = null, RedisEnterpriseClusterResourceState? resourceState = null, RedisEnterpriseClusteringPolicy? clusteringPolicy = null, RedisEnterpriseEvictionPolicy? evictionPolicy = null, RedisPersistenceSettings persistence = null, IEnumerable<RedisEnterpriseModule> modules = null, RedisEnterpriseDatabaseGeoReplication geoReplication = null, string redisVersion = null, DeferUpgradeSetting? deferUpgrade = null, AccessKeysAuthentication? accessKeysAuthentication = null)
        {
            modules ??= new List<RedisEnterpriseModule>();

            return new RedisEnterpriseDatabaseData(
                id,
                name,
                resourceType,
                systemData,
                clientProtocol,
                port,
                provisioningState,
                resourceState,
                clusteringPolicy,
                evictionPolicy,
                persistence,
                modules?.ToList(),
                geoReplication,
                redisVersion,
                deferUpgrade,
                accessKeysAuthentication,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.RedisEnterpriseModule"/>. </summary>
        /// <param name="name"> The name of the module, e.g. 'RedisBloom', 'RediSearch', 'RedisTimeSeries'. </param>
        /// <param name="args"> Configuration options for the module, e.g. 'ERROR_RATE 0.01 INITIAL_SIZE 400'. </param>
        /// <param name="version"> The version of the module, e.g. '1.0'. </param>
        /// <returns> A new <see cref="Models.RedisEnterpriseModule"/> instance for mocking. </returns>
        public static RedisEnterpriseModule RedisEnterpriseModule(string name = null, string args = null, string version = null)
        {
            return new RedisEnterpriseModule(name, args, version, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.RedisEnterpriseLinkedDatabase"/>. </summary>
        /// <param name="id"> Resource ID of a database resource to link with this database. </param>
        /// <param name="state"> State of the link between the database resources. </param>
        /// <returns> A new <see cref="Models.RedisEnterpriseLinkedDatabase"/> instance for mocking. </returns>
        public static RedisEnterpriseLinkedDatabase RedisEnterpriseLinkedDatabase(ResourceIdentifier id = null, RedisEnterpriseDatabaseLinkState? state = null)
        {
            return new RedisEnterpriseLinkedDatabase(id, state, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.RedisEnterpriseDatabasePatch"/>. </summary>
        /// <param name="clientProtocol"> Specifies whether redis clients can connect using TLS-encrypted or plaintext redis protocols. Default is TLS-encrypted. </param>
        /// <param name="port"> TCP port of the database endpoint. Specified at create time. Defaults to an available port. </param>
        /// <param name="provisioningState"> Current provisioning status of the database. </param>
        /// <param name="resourceState"> Current resource status of the database. </param>
        /// <param name="clusteringPolicy"> Clustering policy - default is OSSCluster. This property must be chosen at create time, and cannot be changed without deleting the database. </param>
        /// <param name="evictionPolicy"> Redis eviction policy - default is VolatileLRU. </param>
        /// <param name="persistence"> Persistence settings. </param>
        /// <param name="modules"> Optional set of redis modules to enable in this database - modules can only be added at creation time. </param>
        /// <param name="geoReplication"> Optional set of properties to configure geo replication for this database. </param>
        /// <param name="redisVersion"> Version of Redis the database is running on, e.g. '6.0'. </param>
        /// <param name="deferUpgrade"> Option to defer upgrade when newest version is released - default is NotDeferred. Learn more: https://aka.ms/redisversionupgrade. </param>
        /// <param name="accessKeysAuthentication"> This property can be Enabled/Disabled to allow or deny access with the current access keys. Can be updated even after database is created. </param>
        /// <returns> A new <see cref="Models.RedisEnterpriseDatabasePatch"/> instance for mocking. </returns>
        public static RedisEnterpriseDatabasePatch RedisEnterpriseDatabasePatch(RedisEnterpriseClientProtocol? clientProtocol = null, int? port = null, RedisEnterpriseProvisioningStatus? provisioningState = null, RedisEnterpriseClusterResourceState? resourceState = null, RedisEnterpriseClusteringPolicy? clusteringPolicy = null, RedisEnterpriseEvictionPolicy? evictionPolicy = null, RedisPersistenceSettings persistence = null, IEnumerable<RedisEnterpriseModule> modules = null, RedisEnterpriseDatabaseGeoReplication geoReplication = null, string redisVersion = null, DeferUpgradeSetting? deferUpgrade = null, AccessKeysAuthentication? accessKeysAuthentication = null)
        {
            modules ??= new List<RedisEnterpriseModule>();

            return new RedisEnterpriseDatabasePatch(
                clientProtocol,
                port,
                provisioningState,
                resourceState,
                clusteringPolicy,
                evictionPolicy,
                persistence,
                modules?.ToList(),
                geoReplication,
                redisVersion,
                deferUpgrade,
                accessKeysAuthentication,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.RedisEnterpriseDataAccessKeys"/>. </summary>
        /// <param name="primaryKey"> The current primary key that clients can use to authenticate. </param>
        /// <param name="secondaryKey"> The current secondary key that clients can use to authenticate. </param>
        /// <returns> A new <see cref="Models.RedisEnterpriseDataAccessKeys"/> instance for mocking. </returns>
        public static RedisEnterpriseDataAccessKeys RedisEnterpriseDataAccessKeys(string primaryKey = null, string secondaryKey = null)
        {
            return new RedisEnterpriseDataAccessKeys(primaryKey, secondaryKey, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="RedisEnterprise.AccessPolicyAssignmentData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="provisioningState"> Current provisioning status of the access policy assignment. </param>
        /// <param name="accessPolicyName"> Name of access policy under specific access policy assignment. Only "default" policy is supported for now. </param>
        /// <param name="userObjectId"> The user associated with the access policy. </param>
        /// <returns> A new <see cref="RedisEnterprise.AccessPolicyAssignmentData"/> instance for mocking. </returns>
        public static AccessPolicyAssignmentData AccessPolicyAssignmentData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, RedisEnterpriseProvisioningStatus? provisioningState = null, string accessPolicyName = null, Guid? userObjectId = null)
        {
            return new AccessPolicyAssignmentData(
                id,
                name,
                resourceType,
                systemData,
                provisioningState,
                accessPolicyName,
                userObjectId != null ? new AccessPolicyAssignmentPropertiesUser(userObjectId, serializedAdditionalRawData: null) : null,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.RedisEnterprisePrivateLinkResource"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="groupId"> The private link resource group id. </param>
        /// <param name="requiredMembers"> The private link resource required member names. </param>
        /// <param name="requiredZoneNames"> The private link resource Private link DNS zone name. </param>
        /// <returns> A new <see cref="Models.RedisEnterprisePrivateLinkResource"/> instance for mocking. </returns>
        public static RedisEnterprisePrivateLinkResource RedisEnterprisePrivateLinkResource(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string groupId = null, IEnumerable<string> requiredMembers = null, IEnumerable<string> requiredZoneNames = null)
        {
            requiredMembers ??= new List<string>();
            requiredZoneNames ??= new List<string>();

            return new RedisEnterprisePrivateLinkResource(
                id,
                name,
                resourceType,
                systemData,
                groupId,
                requiredMembers?.ToList(),
                requiredZoneNames?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="T:Azure.ResourceManager.RedisEnterprise.RedisEnterpriseClusterData" />. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="sku"> The SKU to create, which affects price, performance, and features. </param>
        /// <param name="zones"> The Availability Zones where this cluster will be deployed. </param>
        /// <param name="identity"> The identity of the resource. </param>
        /// <param name="minimumTlsVersion"> The minimum TLS version for the cluster to support, e.g. '1.2'. </param>
        /// <param name="customerManagedKeyEncryption"> Encryption-at-rest configuration for the cluster. </param>
        /// <param name="hostName"> DNS name of the cluster endpoint. </param>
        /// <param name="provisioningState"> Current provisioning status of the cluster. </param>
        /// <param name="resourceState"> Current resource status of the cluster. </param>
        /// <param name="redisVersion"> Version of redis the cluster supports, e.g. '6'. </param>
        /// <param name="privateEndpointConnections"> List of private endpoint connections associated with the specified RedisEnterprise cluster. </param>
        /// <returns> A new <see cref="T:Azure.ResourceManager.RedisEnterprise.RedisEnterpriseClusterData" /> instance for mocking. </returns>
        [EditorBrowsable(EditorBrowsableState.Never)]
        public static RedisEnterpriseClusterData RedisEnterpriseClusterData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, IDictionary<string, string> tags, AzureLocation location, RedisEnterpriseSku sku, IEnumerable<string> zones, ManagedServiceIdentity identity, RedisEnterpriseTlsVersion? minimumTlsVersion, RedisEnterpriseCustomerManagedKeyEncryption customerManagedKeyEncryption, string hostName, RedisEnterpriseProvisioningStatus? provisioningState, RedisEnterpriseClusterResourceState? resourceState, string redisVersion, IEnumerable<RedisEnterprisePrivateEndpointConnectionData> privateEndpointConnections)
        {
            return RedisEnterpriseClusterData(id: id, name: name, resourceType: resourceType, systemData: systemData, tags: tags, location: location, sku: sku, zones: zones, identity: identity, highAvailability: default, minimumTlsVersion: minimumTlsVersion, customerManagedKeyEncryption: customerManagedKeyEncryption, hostName: hostName, provisioningState: provisioningState, redundancyMode: default, resourceState: resourceState, redisVersion: redisVersion, privateEndpointConnections: privateEndpointConnections);
        }

        /// <summary> Initializes a new instance of <see cref="T:Azure.ResourceManager.RedisEnterprise.Models.RedisEnterpriseClusterPatch" />. </summary>
        /// <param name="sku"> The SKU to create, which affects price, performance, and features. </param>
        /// <param name="identity"> The identity of the resource. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="minimumTlsVersion"> The minimum TLS version for the cluster to support, e.g. '1.2'. </param>
        /// <param name="customerManagedKeyEncryption"> Encryption-at-rest configuration for the cluster. </param>
        /// <param name="hostName"> DNS name of the cluster endpoint. </param>
        /// <param name="provisioningState"> Current provisioning status of the cluster. </param>
        /// <param name="resourceState"> Current resource status of the cluster. </param>
        /// <param name="redisVersion"> Version of redis the cluster supports, e.g. '6'. </param>
        /// <param name="privateEndpointConnections"> List of private endpoint connections associated with the specified RedisEnterprise cluster. </param>
        /// <returns> A new <see cref="T:Azure.ResourceManager.RedisEnterprise.Models.RedisEnterpriseClusterPatch" /> instance for mocking. </returns>
        [EditorBrowsable(EditorBrowsableState.Never)]
        public static RedisEnterpriseClusterPatch RedisEnterpriseClusterPatch(RedisEnterpriseSku sku, ManagedServiceIdentity identity, IDictionary<string, string> tags, RedisEnterpriseTlsVersion? minimumTlsVersion, RedisEnterpriseCustomerManagedKeyEncryption customerManagedKeyEncryption, string hostName, RedisEnterpriseProvisioningStatus? provisioningState, RedisEnterpriseClusterResourceState? resourceState, string redisVersion, IEnumerable<RedisEnterprisePrivateEndpointConnectionData> privateEndpointConnections)
        {
            return RedisEnterpriseClusterPatch(sku: sku, identity: identity, tags: tags, highAvailability: default, minimumTlsVersion: minimumTlsVersion, customerManagedKeyEncryption: customerManagedKeyEncryption, hostName: hostName, provisioningState: provisioningState, redundancyMode: default, resourceState: resourceState, redisVersion: redisVersion, privateEndpointConnections: privateEndpointConnections);
        }

        /// <summary> Initializes a new instance of <see cref="T:Azure.ResourceManager.RedisEnterprise.RedisEnterpriseDatabaseData" />. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="clientProtocol"> Specifies whether redis clients can connect using TLS-encrypted or plaintext redis protocols. Default is TLS-encrypted. </param>
        /// <param name="port"> TCP port of the database endpoint. Specified at create time. Defaults to an available port. </param>
        /// <param name="provisioningState"> Current provisioning status of the database. </param>
        /// <param name="resourceState"> Current resource status of the database. </param>
        /// <param name="clusteringPolicy"> Clustering policy - default is OSSCluster. Specified at create time. </param>
        /// <param name="evictionPolicy"> Redis eviction policy - default is VolatileLRU. </param>
        /// <param name="persistence"> Persistence settings. </param>
        /// <param name="modules"> Optional set of redis modules to enable in this database - modules can only be added at creation time. </param>
        /// <param name="geoReplication"> Optional set of properties to configure geo replication for this database. </param>
        /// <returns> A new <see cref="T:Azure.ResourceManager.RedisEnterprise.RedisEnterpriseDatabaseData" /> instance for mocking. </returns>
        [EditorBrowsable(EditorBrowsableState.Never)]
        public static RedisEnterpriseDatabaseData RedisEnterpriseDatabaseData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, RedisEnterpriseClientProtocol? clientProtocol, int? port, RedisEnterpriseProvisioningStatus? provisioningState, RedisEnterpriseClusterResourceState? resourceState, RedisEnterpriseClusteringPolicy? clusteringPolicy, RedisEnterpriseEvictionPolicy? evictionPolicy, RedisPersistenceSettings persistence, IEnumerable<RedisEnterpriseModule> modules, RedisEnterpriseDatabaseGeoReplication geoReplication)
        {
            return RedisEnterpriseDatabaseData(id: id, name: name, resourceType: resourceType, systemData: systemData, clientProtocol: clientProtocol, port: port, provisioningState: provisioningState, resourceState: resourceState, clusteringPolicy: clusteringPolicy, evictionPolicy: evictionPolicy, persistence: persistence, modules: modules, geoReplication: geoReplication, redisVersion: default, deferUpgrade: default, accessKeysAuthentication: default);
        }

        /// <summary> Initializes a new instance of <see cref="T:Azure.ResourceManager.RedisEnterprise.Models.RedisEnterpriseDatabasePatch" />. </summary>
        /// <param name="clientProtocol"> Specifies whether redis clients can connect using TLS-encrypted or plaintext redis protocols. Default is TLS-encrypted. </param>
        /// <param name="port"> TCP port of the database endpoint. Specified at create time. Defaults to an available port. </param>
        /// <param name="provisioningState"> Current provisioning status of the database. </param>
        /// <param name="resourceState"> Current resource status of the database. </param>
        /// <param name="clusteringPolicy"> Clustering policy - default is OSSCluster. Specified at create time. </param>
        /// <param name="evictionPolicy"> Redis eviction policy - default is VolatileLRU. </param>
        /// <param name="persistence"> Persistence settings. </param>
        /// <param name="modules"> Optional set of redis modules to enable in this database - modules can only be added at creation time. </param>
        /// <param name="geoReplication"> Optional set of properties to configure geo replication for this database. </param>
        /// <returns> A new <see cref="T:Azure.ResourceManager.RedisEnterprise.Models.RedisEnterpriseDatabasePatch" /> instance for mocking. </returns>
        [EditorBrowsable(EditorBrowsableState.Never)]
        public static RedisEnterpriseDatabasePatch RedisEnterpriseDatabasePatch(RedisEnterpriseClientProtocol? clientProtocol, int? port, RedisEnterpriseProvisioningStatus? provisioningState, RedisEnterpriseClusterResourceState? resourceState, RedisEnterpriseClusteringPolicy? clusteringPolicy, RedisEnterpriseEvictionPolicy? evictionPolicy, RedisPersistenceSettings persistence, IEnumerable<RedisEnterpriseModule> modules, RedisEnterpriseDatabaseGeoReplication geoReplication)
        {
            return RedisEnterpriseDatabasePatch(clientProtocol: clientProtocol, port: port, provisioningState: provisioningState, resourceState: resourceState, clusteringPolicy: clusteringPolicy, evictionPolicy: evictionPolicy, persistence: persistence, modules: modules, geoReplication: geoReplication, redisVersion: default, deferUpgrade: default, accessKeysAuthentication: default);
        }
    }
}
