// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.RedisEnterprise.Samples
{
    public partial class Sample_AccessPolicyAssignmentResource
    {
        // RedisEnterpriseAccessPolicyAssignmentCreateUpdate
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_RedisEnterpriseAccessPolicyAssignmentCreateUpdate()
        {
            // Generated from example definition: specification/redisenterprise/resource-manager/Microsoft.Cache/preview/2024-09-01-preview/examples/RedisEnterpriseAccessPolicyAssignmentCreateUpdate.json
            // this example is just showing the usage of "AccessPolicyAssignment_CreateUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AccessPolicyAssignmentResource created on azure
            // for more information of creating AccessPolicyAssignmentResource, please refer to the document of AccessPolicyAssignmentResource
            string subscriptionId = "e7b5a9d2-6b6a-4d2f-9143-20d9a10f5b8f";
            string resourceGroupName = "rg1";
            string clusterName = "cache1";
            string databaseName = "default";
            string accessPolicyAssignmentName = "defaultTestEntraApp1";
            ResourceIdentifier accessPolicyAssignmentResourceId = AccessPolicyAssignmentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, clusterName, databaseName, accessPolicyAssignmentName);
            AccessPolicyAssignmentResource accessPolicyAssignment = client.GetAccessPolicyAssignmentResource(accessPolicyAssignmentResourceId);

            // invoke the operation
            AccessPolicyAssignmentData data = new AccessPolicyAssignmentData()
            {
                AccessPolicyName = "default",
                UserObjectId = Guid.Parse("6497c918-11ad-41e7-1b0f-7c518a87d0b0"),
            };
            ArmOperation<AccessPolicyAssignmentResource> lro = await accessPolicyAssignment.UpdateAsync(WaitUntil.Completed, data);
            AccessPolicyAssignmentResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            AccessPolicyAssignmentData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // RedisEnterpriseAccessPolicyAssignmentGet
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_RedisEnterpriseAccessPolicyAssignmentGet()
        {
            // Generated from example definition: specification/redisenterprise/resource-manager/Microsoft.Cache/preview/2024-09-01-preview/examples/RedisEnterpriseAccessPolicyAssignmentGet.json
            // this example is just showing the usage of "AccessPolicyAssignment_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AccessPolicyAssignmentResource created on azure
            // for more information of creating AccessPolicyAssignmentResource, please refer to the document of AccessPolicyAssignmentResource
            string subscriptionId = "e7b5a9d2-6b6a-4d2f-9143-20d9a10f5b8f";
            string resourceGroupName = "rg1";
            string clusterName = "cache1";
            string databaseName = "default";
            string accessPolicyAssignmentName = "accessPolicyAssignmentName1";
            ResourceIdentifier accessPolicyAssignmentResourceId = AccessPolicyAssignmentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, clusterName, databaseName, accessPolicyAssignmentName);
            AccessPolicyAssignmentResource accessPolicyAssignment = client.GetAccessPolicyAssignmentResource(accessPolicyAssignmentResourceId);

            // invoke the operation
            AccessPolicyAssignmentResource result = await accessPolicyAssignment.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            AccessPolicyAssignmentData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // RedisEnterpriseAccessPolicyAssignmentDelete
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_RedisEnterpriseAccessPolicyAssignmentDelete()
        {
            // Generated from example definition: specification/redisenterprise/resource-manager/Microsoft.Cache/preview/2024-09-01-preview/examples/RedisEnterpriseAccessPolicyAssignmentDelete.json
            // this example is just showing the usage of "AccessPolicyAssignment_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AccessPolicyAssignmentResource created on azure
            // for more information of creating AccessPolicyAssignmentResource, please refer to the document of AccessPolicyAssignmentResource
            string subscriptionId = "e7b5a9d2-6b6a-4d2f-9143-20d9a10f5b8f";
            string resourceGroupName = "rg1";
            string clusterName = "cache1";
            string databaseName = "default";
            string accessPolicyAssignmentName = "defaultTestEntraApp1";
            ResourceIdentifier accessPolicyAssignmentResourceId = AccessPolicyAssignmentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, clusterName, databaseName, accessPolicyAssignmentName);
            AccessPolicyAssignmentResource accessPolicyAssignment = client.GetAccessPolicyAssignmentResource(accessPolicyAssignmentResourceId);

            // invoke the operation
            await accessPolicyAssignment.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
