// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.Redis.Models;

namespace Azure.ResourceManager.Redis
{
    /// <summary>
    /// A class representing the RedisPatchSchedule data model.
    /// Response to put/get patch schedules for Redis cache.
    /// </summary>
    public partial class RedisPatchScheduleData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="RedisPatchScheduleData"/>. </summary>
        /// <param name="scheduleEntries"> List of patch schedules for a Redis cache. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="scheduleEntries"/> is null. </exception>
        public RedisPatchScheduleData(IEnumerable<RedisPatchScheduleSetting> scheduleEntries)
        {
            Argument.AssertNotNull(scheduleEntries, nameof(scheduleEntries));

            ScheduleEntries = scheduleEntries.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="RedisPatchScheduleData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="location"> The geo-location where the resource lives. </param>
        /// <param name="scheduleEntries"> List of patch schedules for a Redis cache. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal RedisPatchScheduleData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, AzureLocation? location, IList<RedisPatchScheduleSetting> scheduleEntries, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            Location = location;
            ScheduleEntries = scheduleEntries;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="RedisPatchScheduleData"/> for deserialization. </summary>
        internal RedisPatchScheduleData()
        {
        }

        /// <summary> The geo-location where the resource lives. </summary>
        [WirePath("location")]
        public AzureLocation? Location { get; }
        /// <summary> List of patch schedules for a Redis cache. </summary>
        [WirePath("properties.scheduleEntries")]
        public IList<RedisPatchScheduleSetting> ScheduleEntries { get; }
    }
}
