// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Redis.Models
{
    /// <summary> Optional: Specifies the update channel for the monthly Redis updates your Redis Cache will receive. Caches using 'Preview' update channel get latest Redis updates at least 4 weeks ahead of 'Stable' channel caches. Default value is 'Stable'. </summary>
    public readonly partial struct UpdateChannel : IEquatable<UpdateChannel>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="UpdateChannel"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public UpdateChannel(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string StableValue = "Stable";
        private const string PreviewValue = "Preview";

        /// <summary> Stable. </summary>
        public static UpdateChannel Stable { get; } = new UpdateChannel(StableValue);
        /// <summary> Preview. </summary>
        public static UpdateChannel Preview { get; } = new UpdateChannel(PreviewValue);
        /// <summary> Determines if two <see cref="UpdateChannel"/> values are the same. </summary>
        public static bool operator ==(UpdateChannel left, UpdateChannel right) => left.Equals(right);
        /// <summary> Determines if two <see cref="UpdateChannel"/> values are not the same. </summary>
        public static bool operator !=(UpdateChannel left, UpdateChannel right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="UpdateChannel"/>. </summary>
        public static implicit operator UpdateChannel(string value) => new UpdateChannel(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is UpdateChannel other && Equals(other);
        /// <inheritdoc />
        public bool Equals(UpdateChannel other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
