// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Redis.Models
{
    /// <summary> The type of Redis cache to deploy. Valid values: (Basic, Standard, Premium). </summary>
    public readonly partial struct RedisSkuName : IEquatable<RedisSkuName>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RedisSkuName"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RedisSkuName(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string BasicValue = "Basic";
        private const string StandardValue = "Standard";
        private const string PremiumValue = "Premium";

        /// <summary> Basic. </summary>
        public static RedisSkuName Basic { get; } = new RedisSkuName(BasicValue);
        /// <summary> Standard. </summary>
        public static RedisSkuName Standard { get; } = new RedisSkuName(StandardValue);
        /// <summary> Premium. </summary>
        public static RedisSkuName Premium { get; } = new RedisSkuName(PremiumValue);
        /// <summary> Determines if two <see cref="RedisSkuName"/> values are the same. </summary>
        public static bool operator ==(RedisSkuName left, RedisSkuName right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RedisSkuName"/> values are not the same. </summary>
        public static bool operator !=(RedisSkuName left, RedisSkuName right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RedisSkuName"/>. </summary>
        public static implicit operator RedisSkuName(string value) => new RedisSkuName(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RedisSkuName other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RedisSkuName other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
