// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Redis.Models
{
    internal static partial class RedisRegenerateKeyTypeExtensions
    {
        public static string ToSerialString(this RedisRegenerateKeyType value) => value switch
        {
            RedisRegenerateKeyType.Primary => "Primary",
            RedisRegenerateKeyType.Secondary => "Secondary",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown RedisRegenerateKeyType value.")
        };

        public static RedisRegenerateKeyType ToRedisRegenerateKeyType(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Primary")) return RedisRegenerateKeyType.Primary;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Secondary")) return RedisRegenerateKeyType.Secondary;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown RedisRegenerateKeyType value.");
        }
    }
}
