// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Redis.Models
{
    /// <summary> The RedisPatchScheduleDefaultName. </summary>
    public readonly partial struct RedisPatchScheduleDefaultName : IEquatable<RedisPatchScheduleDefaultName>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RedisPatchScheduleDefaultName"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RedisPatchScheduleDefaultName(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DefaultValue = "default";

        /// <summary> default. </summary>
        public static RedisPatchScheduleDefaultName Default { get; } = new RedisPatchScheduleDefaultName(DefaultValue);
        /// <summary> Determines if two <see cref="RedisPatchScheduleDefaultName"/> values are the same. </summary>
        public static bool operator ==(RedisPatchScheduleDefaultName left, RedisPatchScheduleDefaultName right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RedisPatchScheduleDefaultName"/> values are not the same. </summary>
        public static bool operator !=(RedisPatchScheduleDefaultName left, RedisPatchScheduleDefaultName right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RedisPatchScheduleDefaultName"/>. </summary>
        public static implicit operator RedisPatchScheduleDefaultName(string value) => new RedisPatchScheduleDefaultName(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RedisPatchScheduleDefaultName other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RedisPatchScheduleDefaultName other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
