// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Redis.Models
{
    public partial class RedisPatch : IUtf8JsonSerializable, IJsonModel<RedisPatch>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<RedisPatch>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<RedisPatch>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RedisPatch>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(RedisPatch)} does not support writing '{format}' format.");
            }

            if (Optional.IsCollectionDefined(Tags))
            {
                writer.WritePropertyName("tags"u8);
                writer.WriteStartObject();
                foreach (var item in Tags)
                {
                    writer.WritePropertyName(item.Key);
                    writer.WriteStringValue(item.Value);
                }
                writer.WriteEndObject();
            }
            if (Optional.IsDefined(Identity))
            {
                writer.WritePropertyName("identity"u8);
                JsonSerializer.Serialize(writer, Identity);
            }
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (Optional.IsDefined(RedisConfiguration))
            {
                writer.WritePropertyName("redisConfiguration"u8);
                writer.WriteObjectValue(RedisConfiguration, options);
            }
            if (Optional.IsDefined(RedisVersion))
            {
                writer.WritePropertyName("redisVersion"u8);
                writer.WriteStringValue(RedisVersion);
            }
            if (Optional.IsDefined(EnableNonSslPort))
            {
                writer.WritePropertyName("enableNonSslPort"u8);
                writer.WriteBooleanValue(EnableNonSslPort.Value);
            }
            if (Optional.IsDefined(ReplicasPerMaster))
            {
                writer.WritePropertyName("replicasPerMaster"u8);
                writer.WriteNumberValue(ReplicasPerMaster.Value);
            }
            if (Optional.IsDefined(ReplicasPerPrimary))
            {
                writer.WritePropertyName("replicasPerPrimary"u8);
                writer.WriteNumberValue(ReplicasPerPrimary.Value);
            }
            if (Optional.IsCollectionDefined(TenantSettings))
            {
                writer.WritePropertyName("tenantSettings"u8);
                writer.WriteStartObject();
                foreach (var item in TenantSettings)
                {
                    writer.WritePropertyName(item.Key);
                    writer.WriteStringValue(item.Value);
                }
                writer.WriteEndObject();
            }
            if (Optional.IsDefined(ShardCount))
            {
                writer.WritePropertyName("shardCount"u8);
                writer.WriteNumberValue(ShardCount.Value);
            }
            if (Optional.IsDefined(MinimumTlsVersion))
            {
                writer.WritePropertyName("minimumTlsVersion"u8);
                writer.WriteStringValue(MinimumTlsVersion.Value.ToString());
            }
            if (Optional.IsDefined(PublicNetworkAccess))
            {
                writer.WritePropertyName("publicNetworkAccess"u8);
                writer.WriteStringValue(PublicNetworkAccess.Value.ToString());
            }
            if (Optional.IsDefined(UpdateChannel))
            {
                writer.WritePropertyName("updateChannel"u8);
                writer.WriteStringValue(UpdateChannel.Value.ToString());
            }
            if (Optional.IsDefined(IsAccessKeyAuthenticationDisabled))
            {
                writer.WritePropertyName("disableAccessKeyAuthentication"u8);
                writer.WriteBooleanValue(IsAccessKeyAuthenticationDisabled.Value);
            }
            if (Optional.IsDefined(Sku))
            {
                writer.WritePropertyName("sku"u8);
                writer.WriteObjectValue(Sku, options);
            }
            writer.WriteEndObject();
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        RedisPatch IJsonModel<RedisPatch>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RedisPatch>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(RedisPatch)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeRedisPatch(document.RootElement, options);
        }

        internal static RedisPatch DeserializeRedisPatch(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IDictionary<string, string> tags = default;
            ManagedServiceIdentity identity = default;
            RedisCommonConfiguration redisConfiguration = default;
            string redisVersion = default;
            bool? enableNonSslPort = default;
            int? replicasPerMaster = default;
            int? replicasPerPrimary = default;
            IDictionary<string, string> tenantSettings = default;
            int? shardCount = default;
            RedisTlsVersion? minimumTlsVersion = default;
            RedisPublicNetworkAccess? publicNetworkAccess = default;
            UpdateChannel? updateChannel = default;
            bool? disableAccessKeyAuthentication = default;
            RedisSku sku = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("tags"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    Dictionary<string, string> dictionary = new Dictionary<string, string>();
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        dictionary.Add(property0.Name, property0.Value.GetString());
                    }
                    tags = dictionary;
                    continue;
                }
                if (property.NameEquals("identity"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    identity = JsonSerializer.Deserialize<ManagedServiceIdentity>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("redisConfiguration"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            redisConfiguration = RedisCommonConfiguration.DeserializeRedisCommonConfiguration(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("redisVersion"u8))
                        {
                            redisVersion = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("enableNonSslPort"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            enableNonSslPort = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("replicasPerMaster"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            replicasPerMaster = property0.Value.GetInt32();
                            continue;
                        }
                        if (property0.NameEquals("replicasPerPrimary"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            replicasPerPrimary = property0.Value.GetInt32();
                            continue;
                        }
                        if (property0.NameEquals("tenantSettings"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            Dictionary<string, string> dictionary = new Dictionary<string, string>();
                            foreach (var property1 in property0.Value.EnumerateObject())
                            {
                                dictionary.Add(property1.Name, property1.Value.GetString());
                            }
                            tenantSettings = dictionary;
                            continue;
                        }
                        if (property0.NameEquals("shardCount"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            shardCount = property0.Value.GetInt32();
                            continue;
                        }
                        if (property0.NameEquals("minimumTlsVersion"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            minimumTlsVersion = new RedisTlsVersion(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("publicNetworkAccess"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            publicNetworkAccess = new RedisPublicNetworkAccess(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("updateChannel"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            updateChannel = new UpdateChannel(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("disableAccessKeyAuthentication"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            disableAccessKeyAuthentication = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("sku"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            sku = RedisSku.DeserializeRedisSku(property0.Value, options);
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new RedisPatch(
                tags ?? new ChangeTrackingDictionary<string, string>(),
                identity,
                redisConfiguration,
                redisVersion,
                enableNonSslPort,
                replicasPerMaster,
                replicasPerPrimary,
                tenantSettings ?? new ChangeTrackingDictionary<string, string>(),
                shardCount,
                minimumTlsVersion,
                publicNetworkAccess,
                updateChannel,
                disableAccessKeyAuthentication,
                sku,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<RedisPatch>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RedisPatch>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(RedisPatch)} does not support writing '{options.Format}' format.");
            }
        }

        RedisPatch IPersistableModel<RedisPatch>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RedisPatch>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeRedisPatch(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(RedisPatch)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<RedisPatch>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
