// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Redis.Models
{
    internal static partial class RedisLinkedServerRoleExtensions
    {
        public static string ToSerialString(this RedisLinkedServerRole value) => value switch
        {
            RedisLinkedServerRole.Primary => "Primary",
            RedisLinkedServerRole.Secondary => "Secondary",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown RedisLinkedServerRole value.")
        };

        public static RedisLinkedServerRole ToRedisLinkedServerRole(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Primary")) return RedisLinkedServerRole.Primary;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Secondary")) return RedisLinkedServerRole.Secondary;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown RedisLinkedServerRole value.");
        }
    }
}
