// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Redis.Models
{
    /// <summary> List of access policies assignments (with properties) of a Redis cache. </summary>
    internal partial class RedisCacheAccessPolicyAssignmentList
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="RedisCacheAccessPolicyAssignmentList"/>. </summary>
        internal RedisCacheAccessPolicyAssignmentList()
        {
            Value = new ChangeTrackingList<RedisCacheAccessPolicyAssignmentData>();
        }

        /// <summary> Initializes a new instance of <see cref="RedisCacheAccessPolicyAssignmentList"/>. </summary>
        /// <param name="value"> List of access policies assignments (with properties) of a Redis cache. </param>
        /// <param name="nextLink"> Link for next set. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal RedisCacheAccessPolicyAssignmentList(IReadOnlyList<RedisCacheAccessPolicyAssignmentData> value, string nextLink, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Value = value;
            NextLink = nextLink;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> List of access policies assignments (with properties) of a Redis cache. </summary>
        public IReadOnlyList<RedisCacheAccessPolicyAssignmentData> Value { get; }
        /// <summary> Link for next set. </summary>
        public string NextLink { get; }
    }
}
