// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.ResourceManager.Redis.Models
{
    /// <summary> Parameters for Redis import operation. </summary>
    public partial class ImportRdbContent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ImportRdbContent"/>. </summary>
        /// <param name="files"> files to import. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="files"/> is null. </exception>
        public ImportRdbContent(IEnumerable<string> files)
        {
            Argument.AssertNotNull(files, nameof(files));

            Files = files.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="ImportRdbContent"/>. </summary>
        /// <param name="format"> File format. </param>
        /// <param name="files"> files to import. </param>
        /// <param name="preferredDataArchiveAuthMethod"> Preferred auth method to communicate to storage account used for data archive, specify SAS or ManagedIdentity, default value is SAS. </param>
        /// <param name="storageSubscriptionId"> Subscription id of the storage container containing files to import using Managed Identity. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ImportRdbContent(string format, IList<string> files, string preferredDataArchiveAuthMethod, string storageSubscriptionId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Format = format;
            Files = files;
            PreferredDataArchiveAuthMethod = preferredDataArchiveAuthMethod;
            StorageSubscriptionId = storageSubscriptionId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ImportRdbContent"/> for deserialization. </summary>
        internal ImportRdbContent()
        {
        }

        /// <summary> File format. </summary>
        [WirePath("format")]
        public string Format { get; set; }
        /// <summary> files to import. </summary>
        [WirePath("files")]
        public IList<string> Files { get; }
        /// <summary> Preferred auth method to communicate to storage account used for data archive, specify SAS or ManagedIdentity, default value is SAS. </summary>
        [WirePath("preferred-data-archive-auth-method")]
        public string PreferredDataArchiveAuthMethod { get; set; }
        /// <summary> Subscription id of the storage container containing files to import using Managed Identity. </summary>
        [WirePath("storage-subscription-id")]
        public string StorageSubscriptionId { get; set; }
    }
}
