// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Redis.Models
{
    public partial class ExportRdbContent : IUtf8JsonSerializable, IJsonModel<ExportRdbContent>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ExportRdbContent>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ExportRdbContent>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ExportRdbContent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ExportRdbContent)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(Format))
            {
                writer.WritePropertyName("format"u8);
                writer.WriteStringValue(Format);
            }
            writer.WritePropertyName("prefix"u8);
            writer.WriteStringValue(Prefix);
            writer.WritePropertyName("container"u8);
            writer.WriteStringValue(Container);
            if (Optional.IsDefined(PreferredDataArchiveAuthMethod))
            {
                writer.WritePropertyName("preferred-data-archive-auth-method"u8);
                writer.WriteStringValue(PreferredDataArchiveAuthMethod);
            }
            if (Optional.IsDefined(StorageSubscriptionId))
            {
                writer.WritePropertyName("storage-subscription-id"u8);
                writer.WriteStringValue(StorageSubscriptionId);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ExportRdbContent IJsonModel<ExportRdbContent>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ExportRdbContent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ExportRdbContent)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeExportRdbContent(document.RootElement, options);
        }

        internal static ExportRdbContent DeserializeExportRdbContent(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string format = default;
            string prefix = default;
            string container = default;
            string preferredDataArchiveAuthMethod = default;
            string storageSubscriptionId = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("format"u8))
                {
                    format = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("prefix"u8))
                {
                    prefix = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("container"u8))
                {
                    container = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("preferred-data-archive-auth-method"u8))
                {
                    preferredDataArchiveAuthMethod = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("storage-subscription-id"u8))
                {
                    storageSubscriptionId = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ExportRdbContent(
                format,
                prefix,
                container,
                preferredDataArchiveAuthMethod,
                storageSubscriptionId,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<ExportRdbContent>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ExportRdbContent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ExportRdbContent)} does not support writing '{options.Format}' format.");
            }
        }

        ExportRdbContent IPersistableModel<ExportRdbContent>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ExportRdbContent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeExportRdbContent(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ExportRdbContent)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ExportRdbContent>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
