// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Redis.Models
{
    /// <summary> Built-In or Custom access policy. </summary>
    public readonly partial struct AccessPolicyType : IEquatable<AccessPolicyType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AccessPolicyType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AccessPolicyType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CustomValue = "Custom";
        private const string BuiltInValue = "BuiltIn";

        /// <summary> Custom. </summary>
        public static AccessPolicyType Custom { get; } = new AccessPolicyType(CustomValue);
        /// <summary> BuiltIn. </summary>
        public static AccessPolicyType BuiltIn { get; } = new AccessPolicyType(BuiltInValue);
        /// <summary> Determines if two <see cref="AccessPolicyType"/> values are the same. </summary>
        public static bool operator ==(AccessPolicyType left, AccessPolicyType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AccessPolicyType"/> values are not the same. </summary>
        public static bool operator !=(AccessPolicyType left, AccessPolicyType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AccessPolicyType"/>. </summary>
        public static implicit operator AccessPolicyType(string value) => new AccessPolicyType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AccessPolicyType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AccessPolicyType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
