// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Redis.Models
{
    /// <summary> Provisioning state of an access policy assignment set. </summary>
    public readonly partial struct AccessPolicyAssignmentProvisioningState : IEquatable<AccessPolicyAssignmentProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AccessPolicyAssignmentProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AccessPolicyAssignmentProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UpdatingValue = "Updating";
        private const string SucceededValue = "Succeeded";
        private const string DeletingValue = "Deleting";
        private const string DeletedValue = "Deleted";
        private const string CanceledValue = "Canceled";
        private const string FailedValue = "Failed";

        /// <summary> Updating. </summary>
        public static AccessPolicyAssignmentProvisioningState Updating { get; } = new AccessPolicyAssignmentProvisioningState(UpdatingValue);
        /// <summary> Succeeded. </summary>
        public static AccessPolicyAssignmentProvisioningState Succeeded { get; } = new AccessPolicyAssignmentProvisioningState(SucceededValue);
        /// <summary> Deleting. </summary>
        public static AccessPolicyAssignmentProvisioningState Deleting { get; } = new AccessPolicyAssignmentProvisioningState(DeletingValue);
        /// <summary> Deleted. </summary>
        public static AccessPolicyAssignmentProvisioningState Deleted { get; } = new AccessPolicyAssignmentProvisioningState(DeletedValue);
        /// <summary> Canceled. </summary>
        public static AccessPolicyAssignmentProvisioningState Canceled { get; } = new AccessPolicyAssignmentProvisioningState(CanceledValue);
        /// <summary> Failed. </summary>
        public static AccessPolicyAssignmentProvisioningState Failed { get; } = new AccessPolicyAssignmentProvisioningState(FailedValue);
        /// <summary> Determines if two <see cref="AccessPolicyAssignmentProvisioningState"/> values are the same. </summary>
        public static bool operator ==(AccessPolicyAssignmentProvisioningState left, AccessPolicyAssignmentProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AccessPolicyAssignmentProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(AccessPolicyAssignmentProvisioningState left, AccessPolicyAssignmentProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AccessPolicyAssignmentProvisioningState"/>. </summary>
        public static implicit operator AccessPolicyAssignmentProvisioningState(string value) => new AccessPolicyAssignmentProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AccessPolicyAssignmentProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AccessPolicyAssignmentProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
