// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Redis
{
    internal class RedisOperationSource : IOperationSource<RedisResource>
    {
        private readonly ArmClient _client;

        internal RedisOperationSource(ArmClient client)
        {
            _client = client;
        }

        RedisResource IOperationSource<RedisResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = RedisData.DeserializeRedisData(document.RootElement);
            return new RedisResource(_client, data);
        }

        async ValueTask<RedisResource> IOperationSource<RedisResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = RedisData.DeserializeRedisData(document.RootElement);
            return new RedisResource(_client, data);
        }
    }
}
