// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Redis
{
    internal class RedisCacheAccessPolicyOperationSource : IOperationSource<RedisCacheAccessPolicyResource>
    {
        private readonly ArmClient _client;

        internal RedisCacheAccessPolicyOperationSource(ArmClient client)
        {
            _client = client;
        }

        RedisCacheAccessPolicyResource IOperationSource<RedisCacheAccessPolicyResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = RedisCacheAccessPolicyData.DeserializeRedisCacheAccessPolicyData(document.RootElement);
            return new RedisCacheAccessPolicyResource(_client, data);
        }

        async ValueTask<RedisCacheAccessPolicyResource> IOperationSource<RedisCacheAccessPolicyResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = RedisCacheAccessPolicyData.DeserializeRedisCacheAccessPolicyData(document.RootElement);
            return new RedisCacheAccessPolicyResource(_client, data);
        }
    }
}
