// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Redis
{
    internal class RedisCacheAccessPolicyAssignmentOperationSource : IOperationSource<RedisCacheAccessPolicyAssignmentResource>
    {
        private readonly ArmClient _client;

        internal RedisCacheAccessPolicyAssignmentOperationSource(ArmClient client)
        {
            _client = client;
        }

        RedisCacheAccessPolicyAssignmentResource IOperationSource<RedisCacheAccessPolicyAssignmentResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = RedisCacheAccessPolicyAssignmentData.DeserializeRedisCacheAccessPolicyAssignmentData(document.RootElement);
            return new RedisCacheAccessPolicyAssignmentResource(_client, data);
        }

        async ValueTask<RedisCacheAccessPolicyAssignmentResource> IOperationSource<RedisCacheAccessPolicyAssignmentResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = RedisCacheAccessPolicyAssignmentData.DeserializeRedisCacheAccessPolicyAssignmentData(document.RootElement);
            return new RedisCacheAccessPolicyAssignmentResource(_client, data);
        }
    }
}
