// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Redis.Models;

namespace Azure.ResourceManager.Redis.Samples
{
    public partial class Sample_RedisLinkedServerWithPropertyResource
    {
        // LinkedServer_Create
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_LinkedServerCreate()
        {
            // Generated from example definition: specification/redis/resource-manager/Microsoft.Cache/stable/2024-03-01/examples/RedisCacheLinkedServer_Create.json
            // this example is just showing the usage of "LinkedServer_Create" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this RedisLinkedServerWithPropertyResource created on azure
            // for more information of creating RedisLinkedServerWithPropertyResource, please refer to the document of RedisLinkedServerWithPropertyResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string name = "cache1";
            string linkedServerName = "cache2";
            ResourceIdentifier redisLinkedServerWithPropertyResourceId = RedisLinkedServerWithPropertyResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, name, linkedServerName);
            RedisLinkedServerWithPropertyResource redisLinkedServerWithProperty = client.GetRedisLinkedServerWithPropertyResource(redisLinkedServerWithPropertyResourceId);

            // invoke the operation
            RedisLinkedServerWithPropertyCreateOrUpdateContent content = new RedisLinkedServerWithPropertyCreateOrUpdateContent(new ResourceIdentifier("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Cache/Redis/cache2"), new AzureLocation("West US"), RedisLinkedServerRole.Secondary);
            ArmOperation<RedisLinkedServerWithPropertyResource> lro = await redisLinkedServerWithProperty.UpdateAsync(WaitUntil.Completed, content);
            RedisLinkedServerWithPropertyResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            RedisLinkedServerWithPropertyData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // LinkedServerDelete
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_LinkedServerDelete()
        {
            // Generated from example definition: specification/redis/resource-manager/Microsoft.Cache/stable/2024-03-01/examples/RedisCacheLinkedServer_Delete.json
            // this example is just showing the usage of "LinkedServer_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this RedisLinkedServerWithPropertyResource created on azure
            // for more information of creating RedisLinkedServerWithPropertyResource, please refer to the document of RedisLinkedServerWithPropertyResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string name = "cache1";
            string linkedServerName = "cache2";
            ResourceIdentifier redisLinkedServerWithPropertyResourceId = RedisLinkedServerWithPropertyResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, name, linkedServerName);
            RedisLinkedServerWithPropertyResource redisLinkedServerWithProperty = client.GetRedisLinkedServerWithPropertyResource(redisLinkedServerWithPropertyResourceId);

            // invoke the operation
            await redisLinkedServerWithProperty.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // LinkedServer_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_LinkedServerGet()
        {
            // Generated from example definition: specification/redis/resource-manager/Microsoft.Cache/stable/2024-03-01/examples/RedisCacheLinkedServer_Get.json
            // this example is just showing the usage of "LinkedServer_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this RedisLinkedServerWithPropertyResource created on azure
            // for more information of creating RedisLinkedServerWithPropertyResource, please refer to the document of RedisLinkedServerWithPropertyResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string name = "cache1";
            string linkedServerName = "cache2";
            ResourceIdentifier redisLinkedServerWithPropertyResourceId = RedisLinkedServerWithPropertyResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, name, linkedServerName);
            RedisLinkedServerWithPropertyResource redisLinkedServerWithProperty = client.GetRedisLinkedServerWithPropertyResource(redisLinkedServerWithPropertyResourceId);

            // invoke the operation
            RedisLinkedServerWithPropertyResource result = await redisLinkedServerWithProperty.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            RedisLinkedServerWithPropertyData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
