// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Redis.Models;

namespace Azure.ResourceManager.Redis.Samples
{
    public partial class Sample_RedisLinkedServerWithPropertyCollection
    {
        // LinkedServer_Create
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_LinkedServerCreate()
        {
            // Generated from example definition: specification/redis/resource-manager/Microsoft.Cache/stable/2024-03-01/examples/RedisCacheLinkedServer_Create.json
            // this example is just showing the usage of "LinkedServer_Create" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this RedisResource created on azure
            // for more information of creating RedisResource, please refer to the document of RedisResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string name = "cache1";
            ResourceIdentifier redisResourceId = RedisResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, name);
            RedisResource redis = client.GetRedisResource(redisResourceId);

            // get the collection of this RedisLinkedServerWithPropertyResource
            RedisLinkedServerWithPropertyCollection collection = redis.GetRedisLinkedServerWithProperties();

            // invoke the operation
            string linkedServerName = "cache2";
            RedisLinkedServerWithPropertyCreateOrUpdateContent content = new RedisLinkedServerWithPropertyCreateOrUpdateContent(new ResourceIdentifier("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Cache/Redis/cache2"), new AzureLocation("West US"), RedisLinkedServerRole.Secondary);
            ArmOperation<RedisLinkedServerWithPropertyResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, linkedServerName, content);
            RedisLinkedServerWithPropertyResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            RedisLinkedServerWithPropertyData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // LinkedServer_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_LinkedServerGet()
        {
            // Generated from example definition: specification/redis/resource-manager/Microsoft.Cache/stable/2024-03-01/examples/RedisCacheLinkedServer_Get.json
            // this example is just showing the usage of "LinkedServer_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this RedisResource created on azure
            // for more information of creating RedisResource, please refer to the document of RedisResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string name = "cache1";
            ResourceIdentifier redisResourceId = RedisResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, name);
            RedisResource redis = client.GetRedisResource(redisResourceId);

            // get the collection of this RedisLinkedServerWithPropertyResource
            RedisLinkedServerWithPropertyCollection collection = redis.GetRedisLinkedServerWithProperties();

            // invoke the operation
            string linkedServerName = "cache2";
            RedisLinkedServerWithPropertyResource result = await collection.GetAsync(linkedServerName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            RedisLinkedServerWithPropertyData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // LinkedServer_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_LinkedServerGet()
        {
            // Generated from example definition: specification/redis/resource-manager/Microsoft.Cache/stable/2024-03-01/examples/RedisCacheLinkedServer_Get.json
            // this example is just showing the usage of "LinkedServer_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this RedisResource created on azure
            // for more information of creating RedisResource, please refer to the document of RedisResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string name = "cache1";
            ResourceIdentifier redisResourceId = RedisResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, name);
            RedisResource redis = client.GetRedisResource(redisResourceId);

            // get the collection of this RedisLinkedServerWithPropertyResource
            RedisLinkedServerWithPropertyCollection collection = redis.GetRedisLinkedServerWithProperties();

            // invoke the operation
            string linkedServerName = "cache2";
            bool result = await collection.ExistsAsync(linkedServerName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // LinkedServer_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_LinkedServerGet()
        {
            // Generated from example definition: specification/redis/resource-manager/Microsoft.Cache/stable/2024-03-01/examples/RedisCacheLinkedServer_Get.json
            // this example is just showing the usage of "LinkedServer_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this RedisResource created on azure
            // for more information of creating RedisResource, please refer to the document of RedisResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string name = "cache1";
            ResourceIdentifier redisResourceId = RedisResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, name);
            RedisResource redis = client.GetRedisResource(redisResourceId);

            // get the collection of this RedisLinkedServerWithPropertyResource
            RedisLinkedServerWithPropertyCollection collection = redis.GetRedisLinkedServerWithProperties();

            // invoke the operation
            string linkedServerName = "cache2";
            NullableResponse<RedisLinkedServerWithPropertyResource> response = await collection.GetIfExistsAsync(linkedServerName);
            RedisLinkedServerWithPropertyResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                RedisLinkedServerWithPropertyData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // LinkedServer_List
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_LinkedServerList()
        {
            // Generated from example definition: specification/redis/resource-manager/Microsoft.Cache/stable/2024-03-01/examples/RedisCacheLinkedServer_List.json
            // this example is just showing the usage of "LinkedServer_List" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this RedisResource created on azure
            // for more information of creating RedisResource, please refer to the document of RedisResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string name = "cache1";
            ResourceIdentifier redisResourceId = RedisResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, name);
            RedisResource redis = client.GetRedisResource(redisResourceId);

            // get the collection of this RedisLinkedServerWithPropertyResource
            RedisLinkedServerWithPropertyCollection collection = redis.GetRedisLinkedServerWithProperties();

            // invoke the operation and iterate over the result
            await foreach (RedisLinkedServerWithPropertyResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                RedisLinkedServerWithPropertyData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }
    }
}
