// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Net;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.Redis.Samples
{
    public partial class Sample_RedisFirewallRuleResource
    {
        // RedisCacheFirewallRuleCreate
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_RedisCacheFirewallRuleCreate()
        {
            // Generated from example definition: specification/redis/resource-manager/Microsoft.Cache/stable/2024-03-01/examples/RedisCacheFirewallRuleCreate.json
            // this example is just showing the usage of "FirewallRules_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this RedisFirewallRuleResource created on azure
            // for more information of creating RedisFirewallRuleResource, please refer to the document of RedisFirewallRuleResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string cacheName = "cache1";
            string ruleName = "rule1";
            ResourceIdentifier redisFirewallRuleResourceId = RedisFirewallRuleResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, cacheName, ruleName);
            RedisFirewallRuleResource redisFirewallRule = client.GetRedisFirewallRuleResource(redisFirewallRuleResourceId);

            // invoke the operation
            RedisFirewallRuleData data = new RedisFirewallRuleData(IPAddress.Parse("192.168.1.1"), IPAddress.Parse("192.168.1.4"));
            ArmOperation<RedisFirewallRuleResource> lro = await redisFirewallRule.UpdateAsync(WaitUntil.Completed, data);
            RedisFirewallRuleResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            RedisFirewallRuleData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // RedisCacheFirewallRuleGet
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_RedisCacheFirewallRuleGet()
        {
            // Generated from example definition: specification/redis/resource-manager/Microsoft.Cache/stable/2024-03-01/examples/RedisCacheFirewallRuleGet.json
            // this example is just showing the usage of "FirewallRules_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this RedisFirewallRuleResource created on azure
            // for more information of creating RedisFirewallRuleResource, please refer to the document of RedisFirewallRuleResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string cacheName = "cache1";
            string ruleName = "rule1";
            ResourceIdentifier redisFirewallRuleResourceId = RedisFirewallRuleResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, cacheName, ruleName);
            RedisFirewallRuleResource redisFirewallRule = client.GetRedisFirewallRuleResource(redisFirewallRuleResourceId);

            // invoke the operation
            RedisFirewallRuleResource result = await redisFirewallRule.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            RedisFirewallRuleData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // RedisCacheFirewallRuleDelete
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_RedisCacheFirewallRuleDelete()
        {
            // Generated from example definition: specification/redis/resource-manager/Microsoft.Cache/stable/2024-03-01/examples/RedisCacheFirewallRuleDelete.json
            // this example is just showing the usage of "FirewallRules_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this RedisFirewallRuleResource created on azure
            // for more information of creating RedisFirewallRuleResource, please refer to the document of RedisFirewallRuleResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string cacheName = "cache1";
            string ruleName = "rule1";
            ResourceIdentifier redisFirewallRuleResourceId = RedisFirewallRuleResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, cacheName, ruleName);
            RedisFirewallRuleResource redisFirewallRule = client.GetRedisFirewallRuleResource(redisFirewallRuleResourceId);

            // invoke the operation
            await redisFirewallRule.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
