// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.Redis.Samples
{
    public partial class Sample_RedisCacheAccessPolicyResource
    {
        // RedisCacheAccessPolicyCreateUpdate
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_RedisCacheAccessPolicyCreateUpdate()
        {
            // Generated from example definition: specification/redis/resource-manager/Microsoft.Cache/stable/2024-03-01/examples/RedisCacheAccessPolicyCreateUpdate.json
            // this example is just showing the usage of "AccessPolicy_CreateUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this RedisCacheAccessPolicyResource created on azure
            // for more information of creating RedisCacheAccessPolicyResource, please refer to the document of RedisCacheAccessPolicyResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string cacheName = "cache1";
            string accessPolicyName = "accessPolicy1";
            ResourceIdentifier redisCacheAccessPolicyResourceId = RedisCacheAccessPolicyResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, cacheName, accessPolicyName);
            RedisCacheAccessPolicyResource redisCacheAccessPolicy = client.GetRedisCacheAccessPolicyResource(redisCacheAccessPolicyResourceId);

            // invoke the operation
            RedisCacheAccessPolicyData data = new RedisCacheAccessPolicyData()
            {
                Permissions = "+get +hget",
            };
            ArmOperation<RedisCacheAccessPolicyResource> lro = await redisCacheAccessPolicy.UpdateAsync(WaitUntil.Completed, data);
            RedisCacheAccessPolicyResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            RedisCacheAccessPolicyData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // RedisCacheAccessPolicyDelete
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_RedisCacheAccessPolicyDelete()
        {
            // Generated from example definition: specification/redis/resource-manager/Microsoft.Cache/stable/2024-03-01/examples/RedisCacheAccessPolicyDelete.json
            // this example is just showing the usage of "AccessPolicy_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this RedisCacheAccessPolicyResource created on azure
            // for more information of creating RedisCacheAccessPolicyResource, please refer to the document of RedisCacheAccessPolicyResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string cacheName = "cache1";
            string accessPolicyName = "accessPolicy1";
            ResourceIdentifier redisCacheAccessPolicyResourceId = RedisCacheAccessPolicyResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, cacheName, accessPolicyName);
            RedisCacheAccessPolicyResource redisCacheAccessPolicy = client.GetRedisCacheAccessPolicyResource(redisCacheAccessPolicyResourceId);

            // invoke the operation
            await redisCacheAccessPolicy.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // RedisCacheAccessPolicyGet
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_RedisCacheAccessPolicyGet()
        {
            // Generated from example definition: specification/redis/resource-manager/Microsoft.Cache/stable/2024-03-01/examples/RedisCacheAccessPolicyGet.json
            // this example is just showing the usage of "AccessPolicy_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this RedisCacheAccessPolicyResource created on azure
            // for more information of creating RedisCacheAccessPolicyResource, please refer to the document of RedisCacheAccessPolicyResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string cacheName = "cache1";
            string accessPolicyName = "accessPolicy1";
            ResourceIdentifier redisCacheAccessPolicyResourceId = RedisCacheAccessPolicyResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, cacheName, accessPolicyName);
            RedisCacheAccessPolicyResource redisCacheAccessPolicy = client.GetRedisCacheAccessPolicyResource(redisCacheAccessPolicyResourceId);

            // invoke the operation
            RedisCacheAccessPolicyResource result = await redisCacheAccessPolicy.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            RedisCacheAccessPolicyData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
