// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.RecoveryServices
{
    /// <summary>
    /// A class representing the RecoveryServicesVaultExtendedInfo data model.
    /// Vault extended information.
    /// </summary>
    public partial class RecoveryServicesVaultExtendedInfoData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="RecoveryServicesVaultExtendedInfoData"/>. </summary>
        public RecoveryServicesVaultExtendedInfoData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="RecoveryServicesVaultExtendedInfoData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="integrityKey"> Integrity key. </param>
        /// <param name="encryptionKey"> Encryption key. </param>
        /// <param name="encryptionKeyThumbprint"> Encryption key thumbprint. </param>
        /// <param name="algorithm"> Algorithm for Vault ExtendedInfo. </param>
        /// <param name="etag"> Optional ETag. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal RecoveryServicesVaultExtendedInfoData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, string integrityKey, string encryptionKey, string encryptionKeyThumbprint, string algorithm, ETag? etag, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            IntegrityKey = integrityKey;
            EncryptionKey = encryptionKey;
            EncryptionKeyThumbprint = encryptionKeyThumbprint;
            Algorithm = algorithm;
            ETag = etag;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Integrity key. </summary>
        public string IntegrityKey { get; set; }
        /// <summary> Encryption key. </summary>
        public string EncryptionKey { get; set; }
        /// <summary> Encryption key thumbprint. </summary>
        public string EncryptionKeyThumbprint { get; set; }
        /// <summary> Algorithm for Vault ExtendedInfo. </summary>
        public string Algorithm { get; set; }
        /// <summary> Optional ETag. </summary>
        public ETag? ETag { get; set; }
    }
}
