// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServices.Models
{
    /// <summary> Unit of the usage. </summary>
    public readonly partial struct VaultUsageUnit : IEquatable<VaultUsageUnit>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="VaultUsageUnit"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public VaultUsageUnit(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CountValue = "Count";
        private const string BytesValue = "Bytes";
        private const string SecondsValue = "Seconds";
        private const string PercentValue = "Percent";
        private const string CountPerSecondValue = "CountPerSecond";
        private const string BytesPerSecondValue = "BytesPerSecond";

        /// <summary> Count. </summary>
        public static VaultUsageUnit Count { get; } = new VaultUsageUnit(CountValue);
        /// <summary> Bytes. </summary>
        public static VaultUsageUnit Bytes { get; } = new VaultUsageUnit(BytesValue);
        /// <summary> Seconds. </summary>
        public static VaultUsageUnit Seconds { get; } = new VaultUsageUnit(SecondsValue);
        /// <summary> Percent. </summary>
        public static VaultUsageUnit Percent { get; } = new VaultUsageUnit(PercentValue);
        /// <summary> CountPerSecond. </summary>
        public static VaultUsageUnit CountPerSecond { get; } = new VaultUsageUnit(CountPerSecondValue);
        /// <summary> BytesPerSecond. </summary>
        public static VaultUsageUnit BytesPerSecond { get; } = new VaultUsageUnit(BytesPerSecondValue);
        /// <summary> Determines if two <see cref="VaultUsageUnit"/> values are the same. </summary>
        public static bool operator ==(VaultUsageUnit left, VaultUsageUnit right) => left.Equals(right);
        /// <summary> Determines if two <see cref="VaultUsageUnit"/> values are not the same. </summary>
        public static bool operator !=(VaultUsageUnit left, VaultUsageUnit right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="VaultUsageUnit"/>. </summary>
        public static implicit operator VaultUsageUnit(string value) => new VaultUsageUnit(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is VaultUsageUnit other && Equals(other);
        /// <inheritdoc />
        public bool Equals(VaultUsageUnit other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
