// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.RecoveryServices.Models
{
    /// <summary> Usages of a vault. </summary>
    public partial class VaultUsage
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="VaultUsage"/>. </summary>
        internal VaultUsage()
        {
        }

        /// <summary> Initializes a new instance of <see cref="VaultUsage"/>. </summary>
        /// <param name="unit"> Unit of the usage. </param>
        /// <param name="quotaPeriod"> Quota period of usage. </param>
        /// <param name="nextResetOn"> Next reset time of usage. </param>
        /// <param name="currentValue"> Current value of usage. </param>
        /// <param name="limit"> Limit of usage. </param>
        /// <param name="name"> Name of usage. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal VaultUsage(VaultUsageUnit? unit, string quotaPeriod, DateTimeOffset? nextResetOn, long? currentValue, long? limit, VaultUsageNameInfo name, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Unit = unit;
            QuotaPeriod = quotaPeriod;
            NextResetOn = nextResetOn;
            CurrentValue = currentValue;
            Limit = limit;
            Name = name;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Unit of the usage. </summary>
        public VaultUsageUnit? Unit { get; }
        /// <summary> Quota period of usage. </summary>
        public string QuotaPeriod { get; }
        /// <summary> Next reset time of usage. </summary>
        public DateTimeOffset? NextResetOn { get; }
        /// <summary> Current value of usage. </summary>
        public long? CurrentValue { get; }
        /// <summary> Limit of usage. </summary>
        public long? Limit { get; }
        /// <summary> Name of usage. </summary>
        public VaultUsageNameInfo Name { get; }
    }
}
