// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServices.Models
{
    /// <summary> Status of the vault upgrade operation. </summary>
    public readonly partial struct VaultUpgradeState : IEquatable<VaultUpgradeState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="VaultUpgradeState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public VaultUpgradeState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnknownValue = "Unknown";
        private const string InProgressValue = "InProgress";
        private const string UpgradedValue = "Upgraded";
        private const string FailedValue = "Failed";

        /// <summary> Unknown. </summary>
        public static VaultUpgradeState Unknown { get; } = new VaultUpgradeState(UnknownValue);
        /// <summary> InProgress. </summary>
        public static VaultUpgradeState InProgress { get; } = new VaultUpgradeState(InProgressValue);
        /// <summary> Upgraded. </summary>
        public static VaultUpgradeState Upgraded { get; } = new VaultUpgradeState(UpgradedValue);
        /// <summary> Failed. </summary>
        public static VaultUpgradeState Failed { get; } = new VaultUpgradeState(FailedValue);
        /// <summary> Determines if two <see cref="VaultUpgradeState"/> values are the same. </summary>
        public static bool operator ==(VaultUpgradeState left, VaultUpgradeState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="VaultUpgradeState"/> values are not the same. </summary>
        public static bool operator !=(VaultUpgradeState left, VaultUpgradeState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="VaultUpgradeState"/>. </summary>
        public static implicit operator VaultUpgradeState(string value) => new VaultUpgradeState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is VaultUpgradeState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(VaultUpgradeState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
