// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.RecoveryServices.Models
{
    /// <summary> Customer Managed Key details of the resource. </summary>
    public partial class VaultPropertiesEncryption
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="VaultPropertiesEncryption"/>. </summary>
        public VaultPropertiesEncryption()
        {
        }

        /// <summary> Initializes a new instance of <see cref="VaultPropertiesEncryption"/>. </summary>
        /// <param name="keyVaultProperties"> The properties of the Key Vault which hosts CMK. </param>
        /// <param name="kekIdentity"> The details of the identity used for CMK. </param>
        /// <param name="infrastructureEncryption"> Enabling/Disabling the Double Encryption state. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal VaultPropertiesEncryption(CmkKeyVaultProperties keyVaultProperties, CmkKekIdentity kekIdentity, InfrastructureEncryptionState? infrastructureEncryption, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            KeyVaultProperties = keyVaultProperties;
            KekIdentity = kekIdentity;
            InfrastructureEncryption = infrastructureEncryption;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The properties of the Key Vault which hosts CMK. </summary>
        internal CmkKeyVaultProperties KeyVaultProperties { get; set; }
        /// <summary> The key uri of the Customer Managed Key. </summary>
        public Uri KeyUri
        {
            get => KeyVaultProperties is null ? default : KeyVaultProperties.KeyUri;
            set
            {
                if (KeyVaultProperties is null)
                    KeyVaultProperties = new CmkKeyVaultProperties();
                KeyVaultProperties.KeyUri = value;
            }
        }

        /// <summary> The details of the identity used for CMK. </summary>
        public CmkKekIdentity KekIdentity { get; set; }
        /// <summary> Enabling/Disabling the Double Encryption state. </summary>
        public InfrastructureEncryptionState? InfrastructureEncryption { get; set; }
    }
}
