// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServices.Models
{
    public partial class VaultMonitoringSummary : IUtf8JsonSerializable, IJsonModel<VaultMonitoringSummary>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<VaultMonitoringSummary>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<VaultMonitoringSummary>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<VaultMonitoringSummary>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(VaultMonitoringSummary)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(UnHealthyVmCount))
            {
                writer.WritePropertyName("unHealthyVmCount"u8);
                writer.WriteNumberValue(UnHealthyVmCount.Value);
            }
            if (Optional.IsDefined(UnHealthyProviderCount))
            {
                writer.WritePropertyName("unHealthyProviderCount"u8);
                writer.WriteNumberValue(UnHealthyProviderCount.Value);
            }
            if (Optional.IsDefined(EventsCount))
            {
                writer.WritePropertyName("eventsCount"u8);
                writer.WriteNumberValue(EventsCount.Value);
            }
            if (Optional.IsDefined(DeprecatedProviderCount))
            {
                writer.WritePropertyName("deprecatedProviderCount"u8);
                writer.WriteNumberValue(DeprecatedProviderCount.Value);
            }
            if (Optional.IsDefined(SupportedProviderCount))
            {
                writer.WritePropertyName("supportedProviderCount"u8);
                writer.WriteNumberValue(SupportedProviderCount.Value);
            }
            if (Optional.IsDefined(UnsupportedProviderCount))
            {
                writer.WritePropertyName("unsupportedProviderCount"u8);
                writer.WriteNumberValue(UnsupportedProviderCount.Value);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        VaultMonitoringSummary IJsonModel<VaultMonitoringSummary>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<VaultMonitoringSummary>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(VaultMonitoringSummary)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeVaultMonitoringSummary(document.RootElement, options);
        }

        internal static VaultMonitoringSummary DeserializeVaultMonitoringSummary(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            int? unHealthyVmCount = default;
            int? unHealthyProviderCount = default;
            int? eventsCount = default;
            int? deprecatedProviderCount = default;
            int? supportedProviderCount = default;
            int? unsupportedProviderCount = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("unHealthyVmCount"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    unHealthyVmCount = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("unHealthyProviderCount"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    unHealthyProviderCount = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("eventsCount"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    eventsCount = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("deprecatedProviderCount"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    deprecatedProviderCount = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("supportedProviderCount"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    supportedProviderCount = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("unsupportedProviderCount"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    unsupportedProviderCount = property.Value.GetInt32();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new VaultMonitoringSummary(
                unHealthyVmCount,
                unHealthyProviderCount,
                eventsCount,
                deprecatedProviderCount,
                supportedProviderCount,
                unsupportedProviderCount,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<VaultMonitoringSummary>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<VaultMonitoringSummary>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(VaultMonitoringSummary)} does not support writing '{options.Format}' format.");
            }
        }

        VaultMonitoringSummary IPersistableModel<VaultMonitoringSummary>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<VaultMonitoringSummary>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeVaultMonitoringSummary(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(VaultMonitoringSummary)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<VaultMonitoringSummary>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
