// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.RecoveryServices.Models
{
    /// <summary> Monitoring Settings of the vault. </summary>
    public partial class VaultMonitoringSettings
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="VaultMonitoringSettings"/>. </summary>
        public VaultMonitoringSettings()
        {
        }

        /// <summary> Initializes a new instance of <see cref="VaultMonitoringSettings"/>. </summary>
        /// <param name="azureMonitorAlertSettings"> Settings for Azure Monitor based alerts. </param>
        /// <param name="classicAlertSettings"> Settings for classic alerts. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal VaultMonitoringSettings(AzureMonitorAlertSettings azureMonitorAlertSettings, ClassicAlertSettings classicAlertSettings, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            AzureMonitorAlertSettings = azureMonitorAlertSettings;
            ClassicAlertSettings = classicAlertSettings;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Settings for Azure Monitor based alerts. </summary>
        internal AzureMonitorAlertSettings AzureMonitorAlertSettings { get; set; }
        /// <summary> Gets or sets the azure monitor alert alerts for all job failures. </summary>
        public RecoveryServicesAlertsState? AzureMonitorAlertAlertsForAllJobFailures
        {
            get => AzureMonitorAlertSettings is null ? default : AzureMonitorAlertSettings.AlertsForAllJobFailures;
            set
            {
                if (AzureMonitorAlertSettings is null)
                    AzureMonitorAlertSettings = new AzureMonitorAlertSettings();
                AzureMonitorAlertSettings.AlertsForAllJobFailures = value;
            }
        }

        /// <summary> Settings for classic alerts. </summary>
        internal ClassicAlertSettings ClassicAlertSettings { get; set; }
        /// <summary> Gets or sets the classic alert alerts for critical operations. </summary>
        public RecoveryServicesAlertsState? ClassicAlertAlertsForCriticalOperations
        {
            get => ClassicAlertSettings is null ? default : ClassicAlertSettings.AlertsForCriticalOperations;
            set
            {
                if (ClassicAlertSettings is null)
                    ClassicAlertSettings = new ClassicAlertSettings();
                ClassicAlertSettings.AlertsForCriticalOperations = value;
            }
        }
    }
}
