// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServices.Models
{
    /// <summary> The storage redundancy setting of a vault. </summary>
    public readonly partial struct StandardTierStorageRedundancy : IEquatable<StandardTierStorageRedundancy>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="StandardTierStorageRedundancy"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public StandardTierStorageRedundancy(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string LocallyRedundantValue = "LocallyRedundant";
        private const string GeoRedundantValue = "GeoRedundant";
        private const string ZoneRedundantValue = "ZoneRedundant";

        /// <summary> LocallyRedundant. </summary>
        public static StandardTierStorageRedundancy LocallyRedundant { get; } = new StandardTierStorageRedundancy(LocallyRedundantValue);
        /// <summary> GeoRedundant. </summary>
        public static StandardTierStorageRedundancy GeoRedundant { get; } = new StandardTierStorageRedundancy(GeoRedundantValue);
        /// <summary> ZoneRedundant. </summary>
        public static StandardTierStorageRedundancy ZoneRedundant { get; } = new StandardTierStorageRedundancy(ZoneRedundantValue);
        /// <summary> Determines if two <see cref="StandardTierStorageRedundancy"/> values are the same. </summary>
        public static bool operator ==(StandardTierStorageRedundancy left, StandardTierStorageRedundancy right) => left.Equals(right);
        /// <summary> Determines if two <see cref="StandardTierStorageRedundancy"/> values are not the same. </summary>
        public static bool operator !=(StandardTierStorageRedundancy left, StandardTierStorageRedundancy right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="StandardTierStorageRedundancy"/>. </summary>
        public static implicit operator StandardTierStorageRedundancy(string value) => new StandardTierStorageRedundancy(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is StandardTierStorageRedundancy other && Equals(other);
        /// <inheritdoc />
        public bool Equals(StandardTierStorageRedundancy other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
