// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.RecoveryServices.Models
{
    /// <summary> Restore Settings  of the vault. </summary>
    internal partial class RestoreSettings
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="RestoreSettings"/>. </summary>
        public RestoreSettings()
        {
        }

        /// <summary> Initializes a new instance of <see cref="RestoreSettings"/>. </summary>
        /// <param name="crossSubscriptionRestoreSettings"> Settings for CrossSubscriptionRestore. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal RestoreSettings(CrossSubscriptionRestoreSettings crossSubscriptionRestoreSettings, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            CrossSubscriptionRestoreSettings = crossSubscriptionRestoreSettings;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Settings for CrossSubscriptionRestore. </summary>
        internal CrossSubscriptionRestoreSettings CrossSubscriptionRestoreSettings { get; set; }
        /// <summary> Gets or sets the cross subscription restore state. </summary>
        public CrossSubscriptionRestoreState? CrossSubscriptionRestoreState
        {
            get => CrossSubscriptionRestoreSettings is null ? default : CrossSubscriptionRestoreSettings.CrossSubscriptionRestoreState;
            set
            {
                if (CrossSubscriptionRestoreSettings is null)
                    CrossSubscriptionRestoreSettings = new CrossSubscriptionRestoreSettings();
                CrossSubscriptionRestoreSettings.CrossSubscriptionRestoreState = value;
            }
        }
    }
}
