// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServices.Models
{
    /// <summary> The State of the Resource after the move operation. </summary>
    public readonly partial struct ResourceMoveState : IEquatable<ResourceMoveState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ResourceMoveState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ResourceMoveState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnknownValue = "Unknown";
        private const string InProgressValue = "InProgress";
        private const string PrepareFailedValue = "PrepareFailed";
        private const string CommitFailedValue = "CommitFailed";
        private const string PrepareTimedoutValue = "PrepareTimedout";
        private const string CommitTimedoutValue = "CommitTimedout";
        private const string MoveSucceededValue = "MoveSucceeded";
        private const string FailureValue = "Failure";
        private const string CriticalFailureValue = "CriticalFailure";
        private const string PartialSuccessValue = "PartialSuccess";

        /// <summary> Unknown. </summary>
        public static ResourceMoveState Unknown { get; } = new ResourceMoveState(UnknownValue);
        /// <summary> InProgress. </summary>
        public static ResourceMoveState InProgress { get; } = new ResourceMoveState(InProgressValue);
        /// <summary> PrepareFailed. </summary>
        public static ResourceMoveState PrepareFailed { get; } = new ResourceMoveState(PrepareFailedValue);
        /// <summary> CommitFailed. </summary>
        public static ResourceMoveState CommitFailed { get; } = new ResourceMoveState(CommitFailedValue);
        /// <summary> PrepareTimedout. </summary>
        public static ResourceMoveState PrepareTimedout { get; } = new ResourceMoveState(PrepareTimedoutValue);
        /// <summary> CommitTimedout. </summary>
        public static ResourceMoveState CommitTimedout { get; } = new ResourceMoveState(CommitTimedoutValue);
        /// <summary> MoveSucceeded. </summary>
        public static ResourceMoveState MoveSucceeded { get; } = new ResourceMoveState(MoveSucceededValue);
        /// <summary> Failure. </summary>
        public static ResourceMoveState Failure { get; } = new ResourceMoveState(FailureValue);
        /// <summary> CriticalFailure. </summary>
        public static ResourceMoveState CriticalFailure { get; } = new ResourceMoveState(CriticalFailureValue);
        /// <summary> PartialSuccess. </summary>
        public static ResourceMoveState PartialSuccess { get; } = new ResourceMoveState(PartialSuccessValue);
        /// <summary> Determines if two <see cref="ResourceMoveState"/> values are the same. </summary>
        public static bool operator ==(ResourceMoveState left, ResourceMoveState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ResourceMoveState"/> values are not the same. </summary>
        public static bool operator !=(ResourceMoveState left, ResourceMoveState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ResourceMoveState"/>. </summary>
        public static implicit operator ResourceMoveState(string value) => new ResourceMoveState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ResourceMoveState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ResourceMoveState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
