// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServices.Models
{
    /// <summary> Certificate details representing the Vault credentials for AAD. </summary>
    public partial class ResourceCertificateAndAadDetails : ResourceCertificateDetails
    {
        /// <summary> Initializes a new instance of <see cref="ResourceCertificateAndAadDetails"/>. </summary>
        /// <param name="aadAuthority"> AAD tenant authority. </param>
        /// <param name="aadTenantId"> AAD tenant Id. </param>
        /// <param name="servicePrincipalClientId"> AAD service principal clientId. </param>
        /// <param name="servicePrincipalObjectId"> AAD service principal ObjectId. </param>
        /// <param name="azureManagementEndpointAudience"> Azure Management Endpoint Audience. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="aadAuthority"/>, <paramref name="servicePrincipalClientId"/>, <paramref name="servicePrincipalObjectId"/> or <paramref name="azureManagementEndpointAudience"/> is null. </exception>
        internal ResourceCertificateAndAadDetails(string aadAuthority, Guid aadTenantId, string servicePrincipalClientId, string servicePrincipalObjectId, string azureManagementEndpointAudience)
        {
            Argument.AssertNotNull(aadAuthority, nameof(aadAuthority));
            Argument.AssertNotNull(servicePrincipalClientId, nameof(servicePrincipalClientId));
            Argument.AssertNotNull(servicePrincipalObjectId, nameof(servicePrincipalObjectId));
            Argument.AssertNotNull(azureManagementEndpointAudience, nameof(azureManagementEndpointAudience));

            AadAuthority = aadAuthority;
            AadTenantId = aadTenantId;
            ServicePrincipalClientId = servicePrincipalClientId;
            ServicePrincipalObjectId = servicePrincipalObjectId;
            AzureManagementEndpointAudience = azureManagementEndpointAudience;
            AuthType = "AzureActiveDirectory";
        }

        /// <summary> Initializes a new instance of <see cref="ResourceCertificateAndAadDetails"/>. </summary>
        /// <param name="authType"> This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types. </param>
        /// <param name="certificate"> The base64 encoded certificate raw data string. </param>
        /// <param name="friendlyName"> Certificate friendly name. </param>
        /// <param name="issuer"> Certificate issuer. </param>
        /// <param name="resourceId"> Resource ID of the vault. </param>
        /// <param name="subject"> Certificate Subject Name. </param>
        /// <param name="thumbprint"> Certificate thumbprint. </param>
        /// <param name="validStartOn"> Certificate Validity start Date time. </param>
        /// <param name="validEndOn"> Certificate Validity End Date time. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="aadAuthority"> AAD tenant authority. </param>
        /// <param name="aadTenantId"> AAD tenant Id. </param>
        /// <param name="servicePrincipalClientId"> AAD service principal clientId. </param>
        /// <param name="servicePrincipalObjectId"> AAD service principal ObjectId. </param>
        /// <param name="azureManagementEndpointAudience"> Azure Management Endpoint Audience. </param>
        /// <param name="serviceResourceId"> Service Resource Id. </param>
        /// <param name="aadAudience"> AAD audience for the resource. </param>
        internal ResourceCertificateAndAadDetails(string authType, byte[] certificate, string friendlyName, string issuer, long? resourceId, string subject, BinaryData thumbprint, DateTimeOffset? validStartOn, DateTimeOffset? validEndOn, IDictionary<string, BinaryData> serializedAdditionalRawData, string aadAuthority, Guid aadTenantId, string servicePrincipalClientId, string servicePrincipalObjectId, string azureManagementEndpointAudience, ResourceIdentifier serviceResourceId, string aadAudience) : base(authType, certificate, friendlyName, issuer, resourceId, subject, thumbprint, validStartOn, validEndOn, serializedAdditionalRawData)
        {
            AadAuthority = aadAuthority;
            AadTenantId = aadTenantId;
            ServicePrincipalClientId = servicePrincipalClientId;
            ServicePrincipalObjectId = servicePrincipalObjectId;
            AzureManagementEndpointAudience = azureManagementEndpointAudience;
            ServiceResourceId = serviceResourceId;
            AadAudience = aadAudience;
            AuthType = authType ?? "AzureActiveDirectory";
        }

        /// <summary> Initializes a new instance of <see cref="ResourceCertificateAndAadDetails"/> for deserialization. </summary>
        internal ResourceCertificateAndAadDetails()
        {
        }

        /// <summary> AAD tenant authority. </summary>
        public string AadAuthority { get; }
        /// <summary> AAD tenant Id. </summary>
        public Guid AadTenantId { get; }
        /// <summary> AAD service principal clientId. </summary>
        public string ServicePrincipalClientId { get; }
        /// <summary> AAD service principal ObjectId. </summary>
        public string ServicePrincipalObjectId { get; }
        /// <summary> Azure Management Endpoint Audience. </summary>
        public string AzureManagementEndpointAudience { get; }
        /// <summary> Service Resource Id. </summary>
        public ResourceIdentifier ServiceResourceId { get; }
        /// <summary> AAD audience for the resource. </summary>
        public string AadAudience { get; }
    }
}
