// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServices.Models
{
    public partial class ReplicationJobSummary : IUtf8JsonSerializable, IJsonModel<ReplicationJobSummary>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ReplicationJobSummary>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ReplicationJobSummary>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ReplicationJobSummary>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ReplicationJobSummary)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(FailedJobs))
            {
                writer.WritePropertyName("failedJobs"u8);
                writer.WriteNumberValue(FailedJobs.Value);
            }
            if (Optional.IsDefined(SuspendedJobs))
            {
                writer.WritePropertyName("suspendedJobs"u8);
                writer.WriteNumberValue(SuspendedJobs.Value);
            }
            if (Optional.IsDefined(InProgressJobs))
            {
                writer.WritePropertyName("inProgressJobs"u8);
                writer.WriteNumberValue(InProgressJobs.Value);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ReplicationJobSummary IJsonModel<ReplicationJobSummary>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ReplicationJobSummary>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ReplicationJobSummary)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeReplicationJobSummary(document.RootElement, options);
        }

        internal static ReplicationJobSummary DeserializeReplicationJobSummary(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            int? failedJobs = default;
            int? suspendedJobs = default;
            int? inProgressJobs = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("failedJobs"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    failedJobs = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("suspendedJobs"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    suspendedJobs = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("inProgressJobs"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    inProgressJobs = property.Value.GetInt32();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ReplicationJobSummary(failedJobs, suspendedJobs, inProgressJobs, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<ReplicationJobSummary>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ReplicationJobSummary>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ReplicationJobSummary)} does not support writing '{options.Format}' format.");
            }
        }

        ReplicationJobSummary IPersistableModel<ReplicationJobSummary>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ReplicationJobSummary>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeReplicationJobSummary(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ReplicationJobSummary)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ReplicationJobSummary>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
