// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServices.Models
{
    public partial class RecoveryServicesVaultProperties : IUtf8JsonSerializable, IJsonModel<RecoveryServicesVaultProperties>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<RecoveryServicesVaultProperties>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<RecoveryServicesVaultProperties>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RecoveryServicesVaultProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(RecoveryServicesVaultProperties)} does not support writing '{format}' format.");
            }

            if (options.Format != "W" && Optional.IsDefined(ProvisioningState))
            {
                writer.WritePropertyName("provisioningState"u8);
                writer.WriteStringValue(ProvisioningState);
            }
            if (Optional.IsDefined(UpgradeDetails))
            {
                writer.WritePropertyName("upgradeDetails"u8);
                writer.WriteObjectValue(UpgradeDetails, options);
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(PrivateEndpointConnections))
            {
                writer.WritePropertyName("privateEndpointConnections"u8);
                writer.WriteStartArray();
                foreach (var item in PrivateEndpointConnections)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsDefined(PrivateEndpointStateForBackup))
            {
                writer.WritePropertyName("privateEndpointStateForBackup"u8);
                writer.WriteStringValue(PrivateEndpointStateForBackup.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(PrivateEndpointStateForSiteRecovery))
            {
                writer.WritePropertyName("privateEndpointStateForSiteRecovery"u8);
                writer.WriteStringValue(PrivateEndpointStateForSiteRecovery.Value.ToString());
            }
            if (Optional.IsDefined(Encryption))
            {
                writer.WritePropertyName("encryption"u8);
                writer.WriteObjectValue(Encryption, options);
            }
            if (Optional.IsDefined(MoveDetails))
            {
                writer.WritePropertyName("moveDetails"u8);
                writer.WriteObjectValue(MoveDetails, options);
            }
            if (options.Format != "W" && Optional.IsDefined(MoveState))
            {
                writer.WritePropertyName("moveState"u8);
                writer.WriteStringValue(MoveState.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(BackupStorageVersion))
            {
                writer.WritePropertyName("backupStorageVersion"u8);
                writer.WriteStringValue(BackupStorageVersion.Value.ToString());
            }
            if (Optional.IsDefined(PublicNetworkAccess))
            {
                writer.WritePropertyName("publicNetworkAccess"u8);
                writer.WriteStringValue(PublicNetworkAccess.Value.ToString());
            }
            if (Optional.IsDefined(MonitoringSettings))
            {
                writer.WritePropertyName("monitoringSettings"u8);
                writer.WriteObjectValue(MonitoringSettings, options);
            }
            if (Optional.IsDefined(RestoreSettings))
            {
                writer.WritePropertyName("restoreSettings"u8);
                writer.WriteObjectValue(RestoreSettings, options);
            }
            if (Optional.IsDefined(RedundancySettings))
            {
                writer.WritePropertyName("redundancySettings"u8);
                writer.WriteObjectValue(RedundancySettings, options);
            }
            if (Optional.IsDefined(SecuritySettings))
            {
                writer.WritePropertyName("securitySettings"u8);
                writer.WriteObjectValue(SecuritySettings, options);
            }
            if (options.Format != "W" && Optional.IsDefined(SecureScore))
            {
                writer.WritePropertyName("secureScore"u8);
                writer.WriteStringValue(SecureScore.Value.ToString());
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        RecoveryServicesVaultProperties IJsonModel<RecoveryServicesVaultProperties>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RecoveryServicesVaultProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(RecoveryServicesVaultProperties)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeRecoveryServicesVaultProperties(document.RootElement, options);
        }

        internal static RecoveryServicesVaultProperties DeserializeRecoveryServicesVaultProperties(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string provisioningState = default;
            VaultUpgradeDetails upgradeDetails = default;
            IReadOnlyList<RecoveryServicesPrivateEndpointConnectionVaultProperties> privateEndpointConnections = default;
            VaultPrivateEndpointState? privateEndpointStateForBackup = default;
            VaultPrivateEndpointState? privateEndpointStateForSiteRecovery = default;
            VaultPropertiesEncryption encryption = default;
            VaultPropertiesMoveDetails moveDetails = default;
            ResourceMoveState? moveState = default;
            BackupStorageVersion? backupStorageVersion = default;
            VaultPublicNetworkAccess? publicNetworkAccess = default;
            VaultMonitoringSettings monitoringSettings = default;
            RestoreSettings restoreSettings = default;
            VaultPropertiesRedundancySettings redundancySettings = default;
            RecoveryServicesSecuritySettings securitySettings = default;
            SecureScoreLevel? secureScore = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("provisioningState"u8))
                {
                    provisioningState = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("upgradeDetails"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    upgradeDetails = VaultUpgradeDetails.DeserializeVaultUpgradeDetails(property.Value, options);
                    continue;
                }
                if (property.NameEquals("privateEndpointConnections"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<RecoveryServicesPrivateEndpointConnectionVaultProperties> array = new List<RecoveryServicesPrivateEndpointConnectionVaultProperties>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(RecoveryServicesPrivateEndpointConnectionVaultProperties.DeserializeRecoveryServicesPrivateEndpointConnectionVaultProperties(item, options));
                    }
                    privateEndpointConnections = array;
                    continue;
                }
                if (property.NameEquals("privateEndpointStateForBackup"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    privateEndpointStateForBackup = new VaultPrivateEndpointState(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("privateEndpointStateForSiteRecovery"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    privateEndpointStateForSiteRecovery = new VaultPrivateEndpointState(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("encryption"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    encryption = VaultPropertiesEncryption.DeserializeVaultPropertiesEncryption(property.Value, options);
                    continue;
                }
                if (property.NameEquals("moveDetails"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    moveDetails = VaultPropertiesMoveDetails.DeserializeVaultPropertiesMoveDetails(property.Value, options);
                    continue;
                }
                if (property.NameEquals("moveState"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    moveState = new ResourceMoveState(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("backupStorageVersion"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    backupStorageVersion = new BackupStorageVersion(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("publicNetworkAccess"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    publicNetworkAccess = new VaultPublicNetworkAccess(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("monitoringSettings"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    monitoringSettings = VaultMonitoringSettings.DeserializeVaultMonitoringSettings(property.Value, options);
                    continue;
                }
                if (property.NameEquals("restoreSettings"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    restoreSettings = RestoreSettings.DeserializeRestoreSettings(property.Value, options);
                    continue;
                }
                if (property.NameEquals("redundancySettings"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    redundancySettings = VaultPropertiesRedundancySettings.DeserializeVaultPropertiesRedundancySettings(property.Value, options);
                    continue;
                }
                if (property.NameEquals("securitySettings"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    securitySettings = RecoveryServicesSecuritySettings.DeserializeRecoveryServicesSecuritySettings(property.Value, options);
                    continue;
                }
                if (property.NameEquals("secureScore"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    secureScore = new SecureScoreLevel(property.Value.GetString());
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new RecoveryServicesVaultProperties(
                provisioningState,
                upgradeDetails,
                privateEndpointConnections ?? new ChangeTrackingList<RecoveryServicesPrivateEndpointConnectionVaultProperties>(),
                privateEndpointStateForBackup,
                privateEndpointStateForSiteRecovery,
                encryption,
                moveDetails,
                moveState,
                backupStorageVersion,
                publicNetworkAccess,
                monitoringSettings,
                restoreSettings,
                redundancySettings,
                securitySettings,
                secureScore,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<RecoveryServicesVaultProperties>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RecoveryServicesVaultProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(RecoveryServicesVaultProperties)} does not support writing '{options.Format}' format.");
            }
        }

        RecoveryServicesVaultProperties IPersistableModel<RecoveryServicesVaultProperties>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RecoveryServicesVaultProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeRecoveryServicesVaultProperties(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(RecoveryServicesVaultProperties)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<RecoveryServicesVaultProperties>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
