// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServices.Models
{
    /// <summary> The RecoveryServicesSoftDeleteState. </summary>
    public readonly partial struct RecoveryServicesSoftDeleteState : IEquatable<RecoveryServicesSoftDeleteState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RecoveryServicesSoftDeleteState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RecoveryServicesSoftDeleteState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InvalidValue = "Invalid";
        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";
        private const string AlwaysONValue = "AlwaysON";

        /// <summary> Invalid. </summary>
        public static RecoveryServicesSoftDeleteState Invalid { get; } = new RecoveryServicesSoftDeleteState(InvalidValue);
        /// <summary> Enabled. </summary>
        public static RecoveryServicesSoftDeleteState Enabled { get; } = new RecoveryServicesSoftDeleteState(EnabledValue);
        /// <summary> Disabled. </summary>
        public static RecoveryServicesSoftDeleteState Disabled { get; } = new RecoveryServicesSoftDeleteState(DisabledValue);
        /// <summary> AlwaysON. </summary>
        public static RecoveryServicesSoftDeleteState AlwaysON { get; } = new RecoveryServicesSoftDeleteState(AlwaysONValue);
        /// <summary> Determines if two <see cref="RecoveryServicesSoftDeleteState"/> values are the same. </summary>
        public static bool operator ==(RecoveryServicesSoftDeleteState left, RecoveryServicesSoftDeleteState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RecoveryServicesSoftDeleteState"/> values are not the same. </summary>
        public static bool operator !=(RecoveryServicesSoftDeleteState left, RecoveryServicesSoftDeleteState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RecoveryServicesSoftDeleteState"/>. </summary>
        public static implicit operator RecoveryServicesSoftDeleteState(string value) => new RecoveryServicesSoftDeleteState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RecoveryServicesSoftDeleteState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RecoveryServicesSoftDeleteState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
