// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.RecoveryServices.Models
{
    /// <summary> Security Settings of the vault. </summary>
    public partial class RecoveryServicesSecuritySettings
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="RecoveryServicesSecuritySettings"/>. </summary>
        public RecoveryServicesSecuritySettings()
        {
        }

        /// <summary> Initializes a new instance of <see cref="RecoveryServicesSecuritySettings"/>. </summary>
        /// <param name="immutabilitySettings"> Immutability Settings of a vault. </param>
        /// <param name="softDeleteSettings"> Soft delete Settings of a vault. </param>
        /// <param name="multiUserAuthorization"> MUA Settings of a vault. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal RecoveryServicesSecuritySettings(ImmutabilitySettings immutabilitySettings, RecoveryServicesSoftDeleteSettings softDeleteSettings, MultiUserAuthorization? multiUserAuthorization, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ImmutabilitySettings = immutabilitySettings;
            SoftDeleteSettings = softDeleteSettings;
            MultiUserAuthorization = multiUserAuthorization;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Immutability Settings of a vault. </summary>
        internal ImmutabilitySettings ImmutabilitySettings { get; set; }
        /// <summary> Gets or sets the immutability state. </summary>
        public ImmutabilityState? ImmutabilityState
        {
            get => ImmutabilitySettings is null ? default : ImmutabilitySettings.State;
            set
            {
                if (ImmutabilitySettings is null)
                    ImmutabilitySettings = new ImmutabilitySettings();
                ImmutabilitySettings.State = value;
            }
        }

        /// <summary> Soft delete Settings of a vault. </summary>
        public RecoveryServicesSoftDeleteSettings SoftDeleteSettings { get; set; }
        /// <summary> MUA Settings of a vault. </summary>
        public MultiUserAuthorization? MultiUserAuthorization { get; }
    }
}
