// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServices.Models
{
    /// <summary> Gets or sets the status. </summary>
    public readonly partial struct RecoveryServicesPrivateEndpointConnectionStatus : IEquatable<RecoveryServicesPrivateEndpointConnectionStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RecoveryServicesPrivateEndpointConnectionStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RecoveryServicesPrivateEndpointConnectionStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PendingValue = "Pending";
        private const string ApprovedValue = "Approved";
        private const string RejectedValue = "Rejected";
        private const string DisconnectedValue = "Disconnected";

        /// <summary> Pending. </summary>
        public static RecoveryServicesPrivateEndpointConnectionStatus Pending { get; } = new RecoveryServicesPrivateEndpointConnectionStatus(PendingValue);
        /// <summary> Approved. </summary>
        public static RecoveryServicesPrivateEndpointConnectionStatus Approved { get; } = new RecoveryServicesPrivateEndpointConnectionStatus(ApprovedValue);
        /// <summary> Rejected. </summary>
        public static RecoveryServicesPrivateEndpointConnectionStatus Rejected { get; } = new RecoveryServicesPrivateEndpointConnectionStatus(RejectedValue);
        /// <summary> Disconnected. </summary>
        public static RecoveryServicesPrivateEndpointConnectionStatus Disconnected { get; } = new RecoveryServicesPrivateEndpointConnectionStatus(DisconnectedValue);
        /// <summary> Determines if two <see cref="RecoveryServicesPrivateEndpointConnectionStatus"/> values are the same. </summary>
        public static bool operator ==(RecoveryServicesPrivateEndpointConnectionStatus left, RecoveryServicesPrivateEndpointConnectionStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RecoveryServicesPrivateEndpointConnectionStatus"/> values are not the same. </summary>
        public static bool operator !=(RecoveryServicesPrivateEndpointConnectionStatus left, RecoveryServicesPrivateEndpointConnectionStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RecoveryServicesPrivateEndpointConnectionStatus"/>. </summary>
        public static implicit operator RecoveryServicesPrivateEndpointConnectionStatus(string value) => new RecoveryServicesPrivateEndpointConnectionStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RecoveryServicesPrivateEndpointConnectionStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RecoveryServicesPrivateEndpointConnectionStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
