// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServices.Models
{
    /// <summary> Gets or sets provisioning state of the private endpoint connection. </summary>
    public readonly partial struct RecoveryServicesPrivateEndpointConnectionProvisioningState : IEquatable<RecoveryServicesPrivateEndpointConnectionProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RecoveryServicesPrivateEndpointConnectionProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RecoveryServicesPrivateEndpointConnectionProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string DeletingValue = "Deleting";
        private const string FailedValue = "Failed";
        private const string PendingValue = "Pending";

        /// <summary> Succeeded. </summary>
        public static RecoveryServicesPrivateEndpointConnectionProvisioningState Succeeded { get; } = new RecoveryServicesPrivateEndpointConnectionProvisioningState(SucceededValue);
        /// <summary> Deleting. </summary>
        public static RecoveryServicesPrivateEndpointConnectionProvisioningState Deleting { get; } = new RecoveryServicesPrivateEndpointConnectionProvisioningState(DeletingValue);
        /// <summary> Failed. </summary>
        public static RecoveryServicesPrivateEndpointConnectionProvisioningState Failed { get; } = new RecoveryServicesPrivateEndpointConnectionProvisioningState(FailedValue);
        /// <summary> Pending. </summary>
        public static RecoveryServicesPrivateEndpointConnectionProvisioningState Pending { get; } = new RecoveryServicesPrivateEndpointConnectionProvisioningState(PendingValue);
        /// <summary> Determines if two <see cref="RecoveryServicesPrivateEndpointConnectionProvisioningState"/> values are the same. </summary>
        public static bool operator ==(RecoveryServicesPrivateEndpointConnectionProvisioningState left, RecoveryServicesPrivateEndpointConnectionProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RecoveryServicesPrivateEndpointConnectionProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(RecoveryServicesPrivateEndpointConnectionProvisioningState left, RecoveryServicesPrivateEndpointConnectionProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RecoveryServicesPrivateEndpointConnectionProvisioningState"/>. </summary>
        public static implicit operator RecoveryServicesPrivateEndpointConnectionProvisioningState(string value) => new RecoveryServicesPrivateEndpointConnectionProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RecoveryServicesPrivateEndpointConnectionProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RecoveryServicesPrivateEndpointConnectionProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
