// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Resources.Models;

namespace Azure.ResourceManager.RecoveryServices.Models
{
    /// <summary> Private Endpoint Connection Response Properties. </summary>
    public partial class RecoveryServicesPrivateEndpointConnection
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="RecoveryServicesPrivateEndpointConnection"/>. </summary>
        internal RecoveryServicesPrivateEndpointConnection()
        {
            GroupIds = new ChangeTrackingList<VaultSubResourceType>();
        }

        /// <summary> Initializes a new instance of <see cref="RecoveryServicesPrivateEndpointConnection"/>. </summary>
        /// <param name="provisioningState"> Gets or sets provisioning state of the private endpoint connection. </param>
        /// <param name="privateEndpoint"> The Private Endpoint network resource that is linked to the Private Endpoint connection. </param>
        /// <param name="privateLinkServiceConnectionState"> Gets or sets private link service connection state. </param>
        /// <param name="groupIds"> Group Ids for the Private Endpoint. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal RecoveryServicesPrivateEndpointConnection(RecoveryServicesPrivateEndpointConnectionProvisioningState? provisioningState, SubResource privateEndpoint, RecoveryServicesPrivateLinkServiceConnectionState privateLinkServiceConnectionState, IReadOnlyList<VaultSubResourceType> groupIds, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ProvisioningState = provisioningState;
            PrivateEndpoint = privateEndpoint;
            PrivateLinkServiceConnectionState = privateLinkServiceConnectionState;
            GroupIds = groupIds;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets or sets provisioning state of the private endpoint connection. </summary>
        public RecoveryServicesPrivateEndpointConnectionProvisioningState? ProvisioningState { get; }
        /// <summary> The Private Endpoint network resource that is linked to the Private Endpoint connection. </summary>
        internal SubResource PrivateEndpoint { get; }
        /// <summary> Gets Id. </summary>
        public ResourceIdentifier PrivateEndpointId
        {
            get => PrivateEndpoint?.Id;
        }

        /// <summary> Gets or sets private link service connection state. </summary>
        public RecoveryServicesPrivateLinkServiceConnectionState PrivateLinkServiceConnectionState { get; }
        /// <summary> Group Ids for the Private Endpoint. </summary>
        public IReadOnlyList<VaultSubResourceType> GroupIds { get; }
    }
}
