// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServices.Models
{
    /// <summary> Specifies the authentication type. </summary>
    public readonly partial struct RecoveryServicesAuthType : IEquatable<RecoveryServicesAuthType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RecoveryServicesAuthType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RecoveryServicesAuthType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InvalidValue = "Invalid";
        private const string AcsValue = "ACS";
        private const string AadValue = "AAD";
        private const string AccessControlServiceValue = "AccessControlService";
        private const string AzureActiveDirectoryValue = "AzureActiveDirectory";

        /// <summary> Invalid. </summary>
        public static RecoveryServicesAuthType Invalid { get; } = new RecoveryServicesAuthType(InvalidValue);
        /// <summary> ACS. </summary>
        public static RecoveryServicesAuthType Acs { get; } = new RecoveryServicesAuthType(AcsValue);
        /// <summary> AAD. </summary>
        public static RecoveryServicesAuthType Aad { get; } = new RecoveryServicesAuthType(AadValue);
        /// <summary> AccessControlService. </summary>
        public static RecoveryServicesAuthType AccessControlService { get; } = new RecoveryServicesAuthType(AccessControlServiceValue);
        /// <summary> AzureActiveDirectory. </summary>
        public static RecoveryServicesAuthType AzureActiveDirectory { get; } = new RecoveryServicesAuthType(AzureActiveDirectoryValue);
        /// <summary> Determines if two <see cref="RecoveryServicesAuthType"/> values are the same. </summary>
        public static bool operator ==(RecoveryServicesAuthType left, RecoveryServicesAuthType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RecoveryServicesAuthType"/> values are not the same. </summary>
        public static bool operator !=(RecoveryServicesAuthType left, RecoveryServicesAuthType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RecoveryServicesAuthType"/>. </summary>
        public static implicit operator RecoveryServicesAuthType(string value) => new RecoveryServicesAuthType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RecoveryServicesAuthType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RecoveryServicesAuthType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
