// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.RecoveryServices.Models
{
    /// <summary> Raw certificate data. </summary>
    public partial class RawCertificateData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="RawCertificateData"/>. </summary>
        public RawCertificateData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="RawCertificateData"/>. </summary>
        /// <param name="authType"> Specifies the authentication type. </param>
        /// <param name="certificate"> The base64 encoded certificate raw data string. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal RawCertificateData(RecoveryServicesAuthType? authType, byte[] certificate, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            AuthType = authType;
            Certificate = certificate;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Specifies the authentication type. </summary>
        public RecoveryServicesAuthType? AuthType { get; set; }
        /// <summary> The base64 encoded certificate raw data string. </summary>
        public byte[] Certificate { get; set; }
    }
}
