// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServices.Models
{
    /// <summary> The CrossSubscriptionRestoreState. </summary>
    public readonly partial struct CrossSubscriptionRestoreState : IEquatable<CrossSubscriptionRestoreState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CrossSubscriptionRestoreState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CrossSubscriptionRestoreState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";
        private const string PermanentlyDisabledValue = "PermanentlyDisabled";

        /// <summary> Enabled. </summary>
        public static CrossSubscriptionRestoreState Enabled { get; } = new CrossSubscriptionRestoreState(EnabledValue);
        /// <summary> Disabled. </summary>
        public static CrossSubscriptionRestoreState Disabled { get; } = new CrossSubscriptionRestoreState(DisabledValue);
        /// <summary> PermanentlyDisabled. </summary>
        public static CrossSubscriptionRestoreState PermanentlyDisabled { get; } = new CrossSubscriptionRestoreState(PermanentlyDisabledValue);
        /// <summary> Determines if two <see cref="CrossSubscriptionRestoreState"/> values are the same. </summary>
        public static bool operator ==(CrossSubscriptionRestoreState left, CrossSubscriptionRestoreState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CrossSubscriptionRestoreState"/> values are not the same. </summary>
        public static bool operator !=(CrossSubscriptionRestoreState left, CrossSubscriptionRestoreState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CrossSubscriptionRestoreState"/>. </summary>
        public static implicit operator CrossSubscriptionRestoreState(string value) => new CrossSubscriptionRestoreState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CrossSubscriptionRestoreState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CrossSubscriptionRestoreState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
