// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServices.Models
{
    internal partial class CrossSubscriptionRestoreSettings : IUtf8JsonSerializable, IJsonModel<CrossSubscriptionRestoreSettings>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<CrossSubscriptionRestoreSettings>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<CrossSubscriptionRestoreSettings>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CrossSubscriptionRestoreSettings>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(CrossSubscriptionRestoreSettings)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(CrossSubscriptionRestoreState))
            {
                writer.WritePropertyName("crossSubscriptionRestoreState"u8);
                writer.WriteStringValue(CrossSubscriptionRestoreState.Value.ToString());
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        CrossSubscriptionRestoreSettings IJsonModel<CrossSubscriptionRestoreSettings>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CrossSubscriptionRestoreSettings>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(CrossSubscriptionRestoreSettings)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeCrossSubscriptionRestoreSettings(document.RootElement, options);
        }

        internal static CrossSubscriptionRestoreSettings DeserializeCrossSubscriptionRestoreSettings(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            CrossSubscriptionRestoreState? crossSubscriptionRestoreState = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("crossSubscriptionRestoreState"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    crossSubscriptionRestoreState = new CrossSubscriptionRestoreState(property.Value.GetString());
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new CrossSubscriptionRestoreSettings(crossSubscriptionRestoreState, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<CrossSubscriptionRestoreSettings>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CrossSubscriptionRestoreSettings>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(CrossSubscriptionRestoreSettings)} does not support writing '{options.Format}' format.");
            }
        }

        CrossSubscriptionRestoreSettings IPersistableModel<CrossSubscriptionRestoreSettings>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CrossSubscriptionRestoreSettings>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeCrossSubscriptionRestoreSettings(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(CrossSubscriptionRestoreSettings)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<CrossSubscriptionRestoreSettings>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
