// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServices.Models
{
    /// <summary> Flag to show if Cross Region Restore is enabled on the Vault or not. </summary>
    public readonly partial struct CrossRegionRestore : IEquatable<CrossRegionRestore>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CrossRegionRestore"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CrossRegionRestore(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";

        /// <summary> Enabled. </summary>
        public static CrossRegionRestore Enabled { get; } = new CrossRegionRestore(EnabledValue);
        /// <summary> Disabled. </summary>
        public static CrossRegionRestore Disabled { get; } = new CrossRegionRestore(DisabledValue);
        /// <summary> Determines if two <see cref="CrossRegionRestore"/> values are the same. </summary>
        public static bool operator ==(CrossRegionRestore left, CrossRegionRestore right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CrossRegionRestore"/> values are not the same. </summary>
        public static bool operator !=(CrossRegionRestore left, CrossRegionRestore right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CrossRegionRestore"/>. </summary>
        public static implicit operator CrossRegionRestore(string value) => new CrossRegionRestore(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CrossRegionRestore other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CrossRegionRestore other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
