// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServices.Models
{
    /// <summary> Backup storage version. </summary>
    public readonly partial struct BackupStorageVersion : IEquatable<BackupStorageVersion>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BackupStorageVersion"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BackupStorageVersion(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string V1Value = "V1";
        private const string V2Value = "V2";
        private const string UnassignedValue = "Unassigned";

        /// <summary> V1. </summary>
        public static BackupStorageVersion V1 { get; } = new BackupStorageVersion(V1Value);
        /// <summary> V2. </summary>
        public static BackupStorageVersion V2 { get; } = new BackupStorageVersion(V2Value);
        /// <summary> Unassigned. </summary>
        public static BackupStorageVersion Unassigned { get; } = new BackupStorageVersion(UnassignedValue);
        /// <summary> Determines if two <see cref="BackupStorageVersion"/> values are the same. </summary>
        public static bool operator ==(BackupStorageVersion left, BackupStorageVersion right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BackupStorageVersion"/> values are not the same. </summary>
        public static bool operator !=(BackupStorageVersion left, BackupStorageVersion right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BackupStorageVersion"/>. </summary>
        public static implicit operator BackupStorageVersion(string value) => new BackupStorageVersion(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BackupStorageVersion other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BackupStorageVersion other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
