// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.RecoveryServices.Models;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.RecoveryServices.Samples
{
    public partial class Sample_SubscriptionResourceExtensions
    {
        // Capabilities for Microsoft.RecoveryServices/Vaults
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetRecoveryServiceCapabilities_CapabilitiesForMicrosoftRecoveryServicesVaults()
        {
            // Generated from example definition: specification/recoveryservices/resource-manager/Microsoft.RecoveryServices/stable/2023-04-01/examples/Capabilities.json
            // this example is just showing the usage of "RecoveryServices_Capabilities" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SubscriptionResource created on azure
            // for more information of creating SubscriptionResource, please refer to the document of SubscriptionResource
            string subscriptionId = "77777777-b0c6-47a2-b37c-d8e65a629c18";
            ResourceIdentifier subscriptionResourceId = SubscriptionResource.CreateResourceIdentifier(subscriptionId);
            SubscriptionResource subscriptionResource = client.GetSubscriptionResource(subscriptionResourceId);

            // invoke the operation
            AzureLocation location = new AzureLocation("westus");
            ResourceCapabilities input = new ResourceCapabilities(new ResourceType("Microsoft.RecoveryServices/Vaults"))
            {
                CapabilitiesDnsZones =
{
new DnsZone()
{
SubResource = VaultSubResourceType.AzureBackup,
},new DnsZone()
{
SubResource = VaultSubResourceType.AzureSiteRecovery,
}
},
            };
            CapabilitiesResult result = await subscriptionResource.GetRecoveryServiceCapabilitiesAsync(location, input);

            Console.WriteLine($"Succeeded: {result}");
        }
    }
}
