// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.RecoveryServices.Samples
{
    public partial class Sample_RecoveryServicesPrivateLinkResource
    {
        // Get PrivateLinkResource
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetPrivateLinkResource()
        {
            // Generated from example definition: specification/recoveryservices/resource-manager/Microsoft.RecoveryServices/stable/2023-04-01/examples/GetPrivateLinkResources.json
            // this example is just showing the usage of "PrivateLinkResources_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this RecoveryServicesPrivateLinkResource created on azure
            // for more information of creating RecoveryServicesPrivateLinkResource, please refer to the document of RecoveryServicesPrivateLinkResource
            string subscriptionId = "6c48fa17-39c7-45f1-90ac-47a587128ace";
            string resourceGroupName = "petesting";
            string vaultName = "pemsi-ecy-rsv2";
            string privateLinkResourceName = "backupResource";
            ResourceIdentifier recoveryServicesPrivateLinkResourceId = RecoveryServicesPrivateLinkResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, vaultName, privateLinkResourceName);
            RecoveryServicesPrivateLinkResource recoveryServicesPrivateLinkResource = client.GetRecoveryServicesPrivateLinkResource(recoveryServicesPrivateLinkResourceId);

            // invoke the operation
            RecoveryServicesPrivateLinkResource result = await recoveryServicesPrivateLinkResource.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            RecoveryServicesPrivateLinkResourceData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
